/* Simple Example to demonstrate some basic functionality */
/* 00_simple_macro.rex */
xScriptContext=uno.getScriptContext()  -- get the xScriptContext object

oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
runPresentation = .bsf.dialog~dialogbox("Do you want to start the "-
 "presentation after adding the new slide?", "Question", "question", "YesNo")
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages
pagecount=xDrawPages~XIndexAccess~getCount 
lastPage = pagecount - 1;
/* inserting a new drawpage (slide) */
xDrawPages~insertNewByIndex(pagecount)
xDrawPageLast = xDrawPages~getByIndex(lastPage)~XDrawPage
xDrawPageNew = xDrawPages~getByIndex(pagecount)~XDrawPage
drawPageProps = xDrawPageLast~XPropertySet
widths = drawPageProps~getPropertyValue("Width")
widths = trunc(widths / 2)

CALL bsf.import "com.sun.star.awt.Size", "awtSize"
CALL bsf.import "com.sun.star.awt.Point", "awtPoint"
/* creating, resizing and positioning of the frist textshape */
textShape = xImpressFactory~createInstance("com.sun.star.drawing.TextShape") 
textShape = textShape~XShape
shapeWidth = 10000
shapeHeight = 3000
shapeX = widths - trunc(shapeWidth / 2)
shapeY = 5000
textShape~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))
textShape~setPosition(.awtPoint~new(shapeX, shapeY))	  

/* creating, resizing and positioning of textshape for getting to next page */
nextShape = xImpressFactory~createInstance("com.sun.star.drawing.TextShape") 
nextShape = nextShape~XShape
shapeWidth = 9500
shapeHeight = 1000
shapeX = widths - trunc(shapeWidth / 2)
shapeY = 8000
nextShape~setSize(.awtSize~new(shapeWidth, shapeHeight))
nextShape~setPosition(.awtPoint~new(shapeX, shapeY))	  

/* defining the slide transitions */
xDrawPage1Props = xDrawPageNew~XPropertySet
xDrawPage1Props~setPropertyValue("Change", box("int", 1))
xDrawPage1Props~setPropertyValue("Duration", box("int", 5))

/* adding the shapes to the different drawpages */
xDrawPageLast~add(nextShape)
xDrawPageNew~add(textShape)

/* formating the textshapes */
textShape~XText~setString("Hello Presentation-World!")
textProps = textShape~XPropertySet
CALL makeTextAutoFit textProps

nextShapeProps = nextShape~XPropertySet
nextShapeProps~setPropertyValue("OnClick", -
 bsf.getConstant("com.sun.star.presentation.ClickAction","NEXTPAGE"))
nextShape~XText~setString("Next")
CALL makeTextAutoFit nextShapeProps
nextShapeProps~setPropertyValue("FillStyle",-
 bsf.getConstant("com.sun.star.drawing.FillStyle", "SOLID"))
nextShapeProps~setPropertyValue("FillColor", box("int", "60 a0 20"x ~c2d))

/* start the presentation if asked for it */
if(runPresentation == 0) THEN
  DO
    xPresentation = oDoc~XPresentationSupplier~getPresentation
    xPresentation~bsf.invoke("start")
  END
::requires UNO.CLS   -- load UNO support for OpenOffice.org

::routine  makeTextAutoFit
  use arg props

  props~setPropertyValue("ParaAdjust",-
   bsf.getConstant("com.sun.star.style.ParagraphAdjust", "CENTER"))
  props~setPropertyValue("TextFitToSize",-
   bsf.getConstant("com.sun.star.drawing.TextFitToSizeType","PROPORTIONAL"))
  props~setPropertyValue("TextAutoGrowHeight", box("boolean", .true))
  props~setPropertyValue("TextAutoGrowWidth", box("boolean", .true))
