/* Macro, which generates a progress bar at the bottom of each slide */
/* 01_progressbar.rex */
xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
printable = oDoc~XPrintable

/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages
/* global service manager for shape grouper */
xContext = xScriptContext~getComponentContext
XMcf = xContext~getServiceManager
CALL removeSelection oDoc
/* initialize all variables (height, width, etc.) */

firstDrawPageProps = xDrawPages~getByIndex(0)~XDrawPage~XPropertySet
width = firstDrawPageProps~getPropertyValue("Width")
height = firstDrawPageProps~getPropertyValue("Height")
shapeWidthBorder = width - 1000
shapeHeight = 750
shapeX = 500
shapeY = height - 1250

IF pagecount == 1 THEN
DO
  .bsf.dialog~messageBox("This presentation has only one slide. "-
    "There is no need for a progressbar!", "ERROR", "error")
  EXIT 0
END
CALL getNumberOfVisibleSlides xDrawPages
pagecount=result
step = trunc((width - 1000) / (pagecount - 1))
pagecount=xDrawPages~XIndexAccess~getCount
currentStatus = step
CALL getFirstVisibleSlide xDrawPages
startIndex = result + 1
DO i = 0 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  /* remove existing bars, if necessary */
  xShapes = xDrawPage~XShapes
  DO j = 0 TO xShapes~getCount - 1
     xShape = xShapes~getByIndex(j)
     IF(xShape~XNamed~getName() == "progressbar_group") THEN
     DO
        xShapeGroup = xShape~XShapeGroup
        xDrawPage~remove(xShapeGroup)
     END
  END
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 0 | i < startIndex) THEN
    ITERATE
  /* creating and positioning of border of the bar shape */
  barBorder = xImpressFactory~createInstance(-
    "com.sun.star.drawing.RectangleShape") 
  barBorder = barBorder~XShape
  CALL setSizeAndPosition barBorder, shapeWidthBorder, shapeHeight,-
    shapeX, shapeY
  xDrawPage~add(barBorder)
  barBorderProps=barBorder~XPropertySet
  fillStyles = bsf.wrapStaticFields("com.sun.star.drawing.FillStyle")
  barBorderProps~setPropertyValue("FillStyle", fillStyles~none)
  CALL setShadowAndFormat(barBorderProps)

  /* creating and positioning of the statusbar shape */  
  statusBarShape = xImpressFactory~createInstance(-
    "com.sun.star.drawing.RectangleShape") 
  statusBarShape = statusBarShape~XShape
  CALL setSizeAndPosition statusBarShape, currentStatus, shapeHeight,-
    shapeX, shapeY
  currentStatus = currentStatus + step
  xDrawPage~add(statusBarShape)

  /* changing the colors of the filling */
  statusBarShapeProps=statusBarShape~XPropertySet
  statusBarShapeProps~setPropertyValue("FillStyle",fillStyles~gradient)
  CALL CreateGradientObject
  statusBarShapeProps~setPropertyValue("FillGradient", result)
  statusBarShapeProps~setPropertyValue("LineStyle",-
    bsf.getConstant("com.sun.star.drawing.LineStyle", "NONE"))
  CALL setShadowAndFormat(statusBarShapeProps)  
  
  /* create the group */
  shapeGroup = xMcf~createInstanceWithContext(-
    "com.sun.star.drawing.ShapeCollection", xContext)
  shapeGroup = shapeGroup~XShapes
  shapeGroup~add(barBorder)
  shapeGroup~add(statusBarShape)
  xShapeGrouper = xDrawPage~XShapeGrouper
  xShapeGroup = xShapeGrouper~group(shapeGroup)
  name = xShapeGroup~XNamed 
  name~setName("progressbar_group")   
END
EXIT 0
/* Function for creating the GradientObject */
CreateGradientObject :
  gradient = .bsf~new("com.sun.star.awt.Gradient")
  gradient~Style = bsf.getConstant("com.sun.star.awt.GradientStyle", "LINEAR")
  gradient~StartColor     = 9282303
  gradient~EndColor       = 0
  gradient~Angle          = 120
  gradient~Border         = 0
  gradient~XOffset        = 0
  gradient~YOffset        = 0
  gradient~StartIntensity = 100
  gradient~EndIntensity   = 100
  gradient~StepCount      = 10

  return gradient

/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

/* Returns the index of the first visible slide */
getFirstVisibleSlide :
  USE ARG xDrawPages
  index = -1
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      return i
  END
return index


::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	


/* routine for setting the shadow*/
::routine  setShadowAndFormat
  use arg props

  props~setPropertyValue("CornerRadius", box("int", 300))
  props~setPropertyValue("Shadow", box("boolean", .true))
  props~setPropertyValue("ShadowXDistance", box("int", 150))
  props~setPropertyValue("ShadowYDistance", box("int", 150))
  
/* routine for removing selection*/
::routine  removeSelection
  use arg oDoc

  model= oDoc~XModel
  controller = model~getCurrentController()
  selectionController = controller~XSelectionSupplier
  selected = selectionController~getSelection()
  selectionController~select(.nil)