/* Macro, which generates pacman on his way to his cherries */
/* 02_pacman.rex */
xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages
/* global service manager for shape grouper */
xContext = xScriptContext~getComponentContext
XMcf = xContext~getServiceManager
CALL removeSelection oDoc
/* initialize all variables (height, width, etc.) */

firstDrawPageProps = xDrawPages~getByIndex(0)~XDrawPage~XPropertySet
width = firstDrawPageProps~getPropertyValue("Width")
height = firstDrawPageProps~getPropertyValue("Height")
shapeWidthBorder = width - 1400
shapeHeight = 750
shapeX = 500
shapeY = height - 1500
CALL getNumberOfVisibleSlides xDrawPages
pagecount=result
IF pagecount <= 2 THEN
DO
  .bsf.dialog~messageBox("This presentation has less than three visible slide. "-
    "There is no need for this macro to run!", "ERROR", "error")
  EXIT 0
END
step = trunc( (width - 2500) / (pagecount - 2))
pacmanPositionX = shapeX

CALL GetPresentationDirectory oDoc~getURL
directory = result
separator = .uno~file.separator

CALL getFirstVisibleSlide xDrawPages
startIndex = result + 1
pagecount=xDrawPages~XIndexAccess~getCount 
DO i = 1 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage

  /* remove existing pacmans, if necessary */
  xShapes = xDrawPage~XShapes
  DO j = 0 TO xShapes~getCount - 1
     xShape = xShapes~getByIndex(j)
     IF(xShape~XNamed~getName() == "pacman_scene_group") THEN
     DO
        xShapeGroup = xShape~XShapeGroup
        xDrawPage~remove(xShapeGroup)
     END
  END
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 0 | i < startIndex) THEN
    ITERATE
  /* creating and positioning of pacman */
  pacman = xImpressFactory~createInstance(-
    "com.sun.star.drawing.GraphicObjectShape") 
  pacman = pacman~XShape
  CALL setSizeAndPosition pacman, 1000, 1000, pacmanPositionX, shapeY + 120
  pacmanProps=pacman~XPropertySet
  pacmanProps~setPropertyValue("GraphicURL",-
    uno.convertToURL(directory||separator||"pacman.gif"))
  xDrawPage~add(pacman)

  /* creating and positioning of the cherry */
  cherry = xImpressFactory~createInstance(-
    "com.sun.star.drawing.GraphicObjectShape") 
  cherry = cherry~XShape
  CALL setSizeAndPosition cherry, 1200, 1200, shapeWidthBorder, shapeY
  cherryProps=cherry~XPropertySet
  cherryProps~setPropertyValue("GraphicURL",-
    uno.convertToURL(directory||separator||"cherry.gif"))
  xDrawPage~add(cherry)

  /* create the group */
  shapeGroup = xMcf~createInstanceWithContext(-
    "com.sun.star.drawing.ShapeCollection", xContext)
  shapeGroup = shapeGroup~XShapes
  shapeGroup~add(cherry)
  shapeGroup~add(pacman)

   /* creating and positioning of points */
  IF (i <> pagecount -1) THEN
    DO 
      j = pacmanPositionX + 1200
      DO WHILE j < shapeWidthBorder - 300
        point = xImpressFactory~createInstance(-
          "com.sun.star.drawing.EllipseShape") 
        point = point~XShape
        CALL setSizeAndPosition point, 300, 300, j, shapeY + 500
        j = j + 800
        pointProps=point~XPropertySet
        constant = bsf.getConstant("com.sun.star.drawing.CircleKind", "FULL")
        pointProps~setPropertyValue("CircleKind", constant)
        pointProps~setPropertyValue("FillColor", box("int", "FFFF00"x ~c2d))
        pointProps~setPropertyValue("LineStyle",-
         bsf.getConstant("com.sun.star.drawing.LineStyle", "NONE"))
        xDrawPage~add(point)
        shapeGroup~add(point)
      END
    END
  xShapeGrouper = xDrawPage~XShapeGrouper
  xShapeGroup = xShapeGrouper~group(shapeGroup)
  name = xShapeGroup~XNamed 
  name~setName("pacman_scene_group") 

  pacmanPositionX = pacmanPositionX + step
END

EXIT 0
/* routine for getting the directory of the presentation */
GetPresentationDirectory :
  use arg  path

  separator = .uno~file.separator
  full = REVERSE(uno.convertFromURL(path))
  parse var full "pdo." filename (separator) directory
  directory = REVERSE(directory)

return directory


/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

/* Returns the index of the first visible slide */
getFirstVisibleSlide :
  USE ARG xDrawPages
  index = -1
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      return i
  END
return index

::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	

/* routine for removing selection*/
::routine  removeSelection
  use arg oDoc

  model= oDoc~XModel
  controller = model~getCurrentController()
  selectionController = controller~XSelectionSupplier
  selected = selectionController~getSelection()
  selectionController~select(.nil)