/* Macro, which generates a fuse with a bomb, when the fuse has burned down,
   the bomb will explode */
/* 03_bomb.rex */
xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages
/* global service manager for shape grouper */
xContext = xScriptContext~getComponentContext
XMcf = xContext~getServiceManager
CALL removeSelection oDoc
/* remove the explosion page, if it exists */

CALL getNumberOfVisibleSlides xDrawPages
pagecount=result
IF pagecount <= 2 THEN
DO
  .bsf.dialog~messageBox("This presentation has less than three slide. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END
pagecount=xDrawPages~XIndexAccess~getCount 
DO i = 1 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  IF(xDrawPage~XNamed~getName() == "explosion_page") THEN
  DO
    xDrawPages~remove(xDrawPage)
    ITERATE
  END
END
/* initialize all variables (height, width, etc.) */

CALL getNumberOfVisibleSlides xDrawPages
pagecount=result

firstDrawPageProps = xDrawPages~getByIndex(0)~XDrawPage~XPropertySet
width = firstDrawPageProps~getPropertyValue("Width")
height = firstDrawPageProps~getPropertyValue("Height")
bombPositionX = width - 2500
shapeX = 500
shapeY = height - 2450

step = trunc( (width - 3150) / (pagecount - 2))

positionFlame = shapeX
lengthCord = bombPositionX - 800

CALL GetPresentationDirectory oDoc~getURL
directory = result
separator = .uno~file.separator
CALL getFirstVisibleSlide xDrawPages
startIndex = result + 1
pagecount=xDrawPages~XIndexAccess~getCount 
DO i = 0 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage

  /* remove existing bombs, if necessary */
  xShapes = xDrawPage~XShapes
  DO j = 0 TO xShapes~getCount - 1
     xShape = xShapes~getByIndex(j)
     IF(xShape~XNamed~getName() == "bomb_group") THEN
     DO
        xShapeGroup = xShape~XShapeGroup
        xDrawPage~remove(xShapeGroup)
     END
  END
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 0 | i < startIndex) THEN
    ITERATE
  /* creating and positioning of the bomb */
  bomb = xImpressFactory~createInstance(-
    "com.sun.star.drawing.GraphicObjectShape") 
  bomb = bomb~XShape
  CALL setSizeAndPosition bomb, 2100, 2150, bombPositionX, shapeY
  bombProps=bomb~XPropertySet
  bombProps~setPropertyValue("GraphicURL",-
  	uno.convertToURL(directory||separator||"bomb.gif"))
  xDrawPage~add(bomb)

   /* creating and positioning of the cord */
   cord = xImpressFactory~createInstance(-
     "com.sun.star.drawing.RectangleShape") 
   cord = cord~XShape
   CALL setSizeAndPosition cord, lengthCord, 100,-
     positionFlame + 700, shapeY + 1300
   cordProps=cord~XPropertySet
   cordProps~setPropertyValue("FillColor", box("int", "FFFF00"x ~c2d))
   xDrawPage~add(cord)

   /* creating and positioning of the fuse */
   fuse = xImpressFactory~createInstance(-
     "com.sun.star.drawing.GraphicObjectShape") 
   fuse = fuse~XShape
   CALL setSizeAndPosition fuse, 1000, 1000, positionFlame, shapeY + 940
   fuseProps=fuse~XPropertySet
   fuseProps~setPropertyValue("GraphicURL",-
     uno.convertToURL(directory||separator||"fuse.png"))
   xDrawPage~add(fuse)

   /* create the group */
   shapeGroup = xMcf~createInstanceWithContext(-
     "com.sun.star.drawing.ShapeCollection", xContext)
   shapeGroup = shapeGroup~XShapes
   shapeGroup~add(bomb)
   shapeGroup~add(cord)
   shapeGroup~add(fuse)
   xShapeGrouper = xDrawPage~XShapeGrouper
   xShapeGroup = xShapeGrouper~group(shapeGroup)
   name = xShapeGroup~XNamed 
   name~setName("bomb_group") 

   positionFlame = positionFlame + step
   lengthCord = lengthCord - step
END
 
/* creating, resizing and positioning of the explosion page and content*/
xDrawPages~insertNewByIndex(pagecount)
explosionPage = xDrawPages~getByIndex(pagecount)~XDrawPage
explosionPage~XNamed~setName("explosion_page")
textShape = xImpressFactory~createInstance("com.sun.star.drawing.TextShape") 
textShape = textShape~XShape
CALL setSizeAndPosition textShape, 23000, 3000, 3000, 2000
explosionPage~add(textShape)

explosion = xImpressFactory~createInstance(-
  "com.sun.star.drawing.GraphicObjectShape") 
explosion = explosion~XShape
CALL setSizeAndPosition explosion, 20000, 15000, 4200, 5000
explosionPage~add(explosion)

explosionProps = explosion~XPropertySet
explosionProps~setPropertyValue("GraphicURL",-
  uno.convertToURL(directory||separator||"explosion.jpg"))
textProps = textShape~XPropertySet
textProps~setPropertyValue("TextFitToSize",-
    bsf.getConstant("com.sun.star.drawing.TextFitToSizeType","PROPORTIONAL"))
effects = bsf.wrapStaticFields("com.sun.star.presentation.AnimationEffect")
speeds = bsf.wrapStaticFields("com.sun.star.presentation.AnimationSpeed")
textProps~setPropertyValue("Effect", effects~FADE_FROM_CENTER)
textProps~setPropertyValue("Speed", speeds~FAST)
explosionProps~setPropertyValue("Effect", effects~HORIZONTAL_ROTATE)
explosionProps~setPropertyValue("Speed", speeds~MEDIUM)
	  
/* formating the textshapes */
textShape~XText~setString("BOOOOOOOMMMMM!!!!!!")

explosionPageProps = explosionPage~XPropertySet
explosionPageProps~setPropertyValue("Effect",-
  bsf.getConstant("com.sun.star.presentation.FadeEffect", "RANDOM"))
explosionPageProps~setPropertyValue("Speed", speeds~MEDIUM)

EXIT 0

/* routine for getting the directory of the presentation */
GetPresentationDirectory :
  use arg  path

  separator = .uno~file.separator
  full = REVERSE(uno.convertFromURL(path))
  parse var full "pdo." filename (separator) directory
  directory = REVERSE(directory)

return directory

/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

/* Returns the index of the first visible slide */
getFirstVisibleSlide :
  USE ARG xDrawPages
  index = -1
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      return i
  END
return index

::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	

/* routine for removing selection*/
::routine  removeSelection
  use arg oDoc

  model= oDoc~XModel
  controller = model~getCurrentController()
  selectionController = controller~XSelectionSupplier
  selected = selectionController~getSelection()
  selectionController~select(.nil)