/* Macro, which generates a clock that counts down to the end of the
   presentation */
/* 04_clock.rex */
xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages
/* global service manager for shape grouper */
xContext = xScriptContext~getComponentContext
XMcf = xContext~getServiceManager
CALL removeSelection oDoc
/* initialize all variables (height, width, etc.) */
firstDrawPageProps = xDrawPages~getByIndex(0)~XDrawPage~XPropertySet
width = firstDrawPageProps~getPropertyValue("Width")
height = firstDrawPageProps~getPropertyValue("Height")
bombPositionX = width - 2000
shapeX = 500
shapeY = height - 1250

CALL getNumberOfVisibleSlides xDrawPages
pagecount=result
IF pagecount <= 2 THEN
DO
  .bsf.dialog~messageBox("This presentation has less than three slide! "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

step = trunc((36000) / (pagecount - 2))

/* start at 12 o clock */
endAngle = 9000
startAngle = 9000
stopAngle = -27000
/* start with white */
colorValue = 16777215
stepRed = trunc( 255 / (pagecount - 2))
circleKinds = bsf.wrapStaticFields("com.sun.star.drawing.CircleKind")

pagecount=xDrawPages~XIndexAccess~getCount 
CALL getFirstVisibleSlide xDrawPages
startIndex = result + 1
DO i = 0 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage

  /* remove existing clocks, if necessary */
  xShapes = xDrawPage~XShapes
  DO j = 0 TO xShapes~getCount - 1
     xShape = xShapes~getByIndex(j)
     IF(xShape~XNamed~getName() == "clock_group") THEN
     DO
        xShapeGroup = xShape~XShapeGroup
        xDrawPage~remove(xShapeGroup)
     END
  END
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 0 | i < startIndex) THEN
    ITERATE
  /* creating background shape of the clock */
  clockBackground = xImpressFactory~createInstance(-
    "com.sun.star.drawing.EllipseShape") 
  clockBackground = clockBackground~XShape
  CALL setSizeAndPosition clockBackground, 1500, 1500,-
    trunc(width / 2) - 750, height - 1800
  clockBackgroundProps=clockBackground~XPropertySet
  clockBackgroundProps~setPropertyValue("CircleKind", circleKinds~FULL)
  clockBackgroundProps~setPropertyValue("FillColor",-
    box("int", "FFFFFF"x ~c2d))
  xDrawPage~add(clockBackground)
  
  clock = xImpressFactory~createInstance(-
    "com.sun.star.drawing.EllipseShape") 
  clock = clock~XShape
  CALL setSizeAndPosition clock, 1500, 1500,-
    trunc(width / 2) - 750, height - 1800
  xDrawPage~add(clock)
  clockProps=clock~XPropertySet
  
  /* create the group */
  shapeGroup = xMcf~createInstanceWithContext(-
    "com.sun.star.drawing.ShapeCollection", xContext)
  shapeGroup = shapeGroup~XShapes
  shapeGroup~add(clockBackground)
  shapeGroup~add(clock)
  xShapeGrouper = xDrawPage~XShapeGrouper
  xShapeGroup = xShapeGrouper~group(shapeGroup)
  name = xShapeGroup~XNamed 
  name~setName("clock_group") 

  IF(startAngle <> stopAngle) THEN
    DO
      /* set the start and the end angle for the section */
      clockProps~setPropertyValue("CircleKind", circleKinds~SECTION)
      clockProps~setPropertyValue("CircleStartAngle", box("int", startAngle))
      clockProps~setPropertyValue("CircleEndAngle", box("int", endAngle))
      startAngle = startAngle - step
      /* adjust color */
      color = box("int", colorValue) 
      colorValue = colorValue - (stepRed * 256) - stepRed
    END
  ELSE 
      color = box("int", "FF0000"x ~c2d)
  
  clockProps~setPropertyValue("FillColor", color) 
END

EXIT 0

/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

/* Returns the index of the first visible slide */
getFirstVisibleSlide :
  USE ARG xDrawPages
  index = -1
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      return i
  END
return index


::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	
  
/* routine for removing selection*/
::routine  removeSelection
  use arg oDoc

  model= oDoc~XModel
  controller = model~getCurrentController()
  selectionController = controller~XSelectionSupplier
  selected = selectionController~getSelection()
  selectionController~select(.nil)