/* Macro, which generates a break page with a specfic time to display
   the content. The user can control the duration and the breaktext */
/* 05_break.rex */
/* Exceptionhandling */
SIGNAL ON ANY
xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages

/* check pagecount */
CALL getNumberOfVisibleSlides xDrawPages
pagecount=result 

IF pagecount <= 2 THEN
DO
  .bsf.dialog~messageBox("This presentation has less than three slide. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

/* adjust middle value */	
middle = trunc(pagecount / 2);

IF (pagecount // 2 == 0) THEN
   middle = middle - 1

/* ask user, which text should be displayed and the duration of the break */
minutes = .bsf.dialog~inputBox("How long (minutes) should be the break?",-
  "Question", "question")

/* No input */
if(minutes == "") then
  DO
    .bsf.dialog~messageBox("Not a valid number!", "ERROR", "error")
    EXIT 0
  END
message = .bsf.dialog~inputBox("What text should be displayed?",-
  "Question", "question")
slideCounter = 0
pagecount=xDrawPages~XIndexAccess~getCount
DO i = 0 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  xProps = xDrawPage~XPropertySet
  visibility = xProps~getPropertyValue("Visible")
  IF(visibility == 1) THEN
    slideCounter = slideCounter + 1
  IF(visibility == 1 & slideCounter == middle) THEN
  DO
    /* insert a slide in the middle of the page */
    xDrawPages~insertNewByIndex(i+1)
    beforeBreakPage = xDrawPages~getByIndex(i+1)~XDrawPage
    beforeBreakPageProps = beforeBreakPage~XPropertySet
    beforeBreakPageProps~setPropertyValue("Effect", -
      bsf.getConstant("com.sun.star.presentation.FadeEffect","WAVYLINE_FROM_LEFT"))
  END

  IF(visibility == 1 & slideCounter == middle+1) THEN
  DO
    /* set the duration to the entered value */
    breakPage = xDrawPages~getByIndex(i+1)~XDrawPage
    breakPageProps = breakPage~XPropertySet
    breakPageProps~setPropertyValue("Change", box("int", 1))
    breakPageProps~setPropertyValue("Duration", box("int", minutes * 60))

    /* create the heading of the break slide */
    textShape = xImpressFactory~createInstance("com.sun.star.drawing.TextShape") 
    textShape = textShape~XShape
    CALL setSizeAndPosition textShape, 15000, 3000, 6800, 2000
    textProps = textShape~XPropertySet
    breakPage~add(textShape)

    /* assigning effects */
    textProps~setPropertyValue("TextFitToSize",-
      bsf.getConstant("com.sun.star.drawing.TextFitToSizeType","PROPORTIONAL"))
    animationEffects = bsf.wrapStaticFields(-
      "com.sun.star.presentation.AnimationEffect")
    speeds = bsf.wrapStaticFields("com.sun.star.presentation.AnimationSpeed")
    textProps~setPropertyValue("Effect",animationEffects~RANDOM)
    textProps~setPropertyValue("Speed", speeds~MEDIUM)
    textShape~XText~setString("-- Break --")
    
    messageShape = xImpressFactory~createInstance(-
      "com.sun.star.drawing.TextShape") 
    messageShape = messageShape~XShape
    CALL setSizeAndPosition messageShape, 23000, 2000,-
      2800, 7000
    messageShapeProps=messageShape~XPropertySet
    breakPage~add(messageShape)
    
    /* assigning effects */
    messageShapeProps~setPropertyValue("Effect",-
      animationEffects~COUNTERCLOCKWISE)
    messageShapeProps~setPropertyValue("Speed", speeds~SLOW)
    messageShapeProps~setPropertyValue("FillStyle",-
      bsf.getConstant("com.sun.star.drawing.FillStyle", "NONE"))
    messageShapeProps~setPropertyValue("LineStyle",-
      bsf.getConstant("com.sun.star.drawing.LineStyle", "NONE"))

    breakText = messageShape~XText
    breakText~setString(message)
    LEAVE	
  END
END

EXIT 0
/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

ANY:
   .bsf.dialog~messageBox("Error in line " SIGL "."-
     "Please check your input!", "ERROR", "error")
::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	