/* Macro, which generates different kinds of animations and effects
   the user will be asked for the settings of the presentation */
/* 06_finish_presentation.rex */
/* Exceptionhandling */
SIGNAL ON SYNTAX
xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages

/* check pagecount */
pagecount=xDrawPages~XIndexAccess~getCount 

IF pagecount == 1 THEN
DO
  .bsf.dialog~messageBox("This presentation has only one slide. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

/* show message dialog for slide effects */
arrayEffects = .array~of("NONE", "RANDOM", "DISSOLVE", "CLOCKWISE", -
 "MOVE_FROM_TOP", "FADE_FROM_BOTTOM", "HORIZONTAL_STRIPES", -
 "SPIRALIN_RIGHT", "CLOSE_HORIZONTAL", "ROLL_FROM_TOP")
effect = .bsf.dialog~inputBox("Choose the Effect you like to add to "-
  "the slides!", "Effects", "question", , arrayEffects)
IF(effect == .nil) THEN
  EXIT 0
  
/* show message dialog for speed of transition */
IF(effect <> "NONE") THEN
DO
  arraySpeed = .array~of("SLOW", "MEDIUM", "FAST")
  speed = .bsf.dialog~inputBox("Choose the speed of the transition!",-
    "Effects", "question", , arraySpeed)
  IF(speed == .nil) THEN
    EXIT 0
END

/* ask for the duration of the transition */
linebreak = "0d0a"x
DO UNTIL seconds <> ""
  seconds = .bsf.dialog~inputBox("How long (seconds) should be the ",
    "duration of a slide"||linebreak||"0= manual transition?",-
    "Question", "question")
  if(seconds == .nil) then
    EXIT 0
  /* No input */
  if(seconds == "") then
      .bsf.dialog~messageBox("Not a valid number!", "ERROR", "error")
END

shapeAnimation = .bsf.dialog~dialogBox("Do you want a shape animation?"-
  , "Question", "question", "YesNo")

/* ask for the global shape animation */
IF (shapeAnimation == 0) THEN
DO
  arrayEffects = .array~of("NONE", "RANDOM", "DISSOLVE", "APPEAR", -
   "LASER_FROM_LEFT", "MOVE_TO_BOTTOM", "STRETCH_FROM_LEFT", -
   "WAYLINE_FROM_RIGHT", "ZOOM_OUT", "VERTICAL_LINES")
  effectShapes = .bsf.dialog~inputBox("Choose the Effect you like to add to "-
    "the shapes!", "Effects", "question", , arrayEffects)
  IF(effectShapes == .nil) THEN
    EXIT 0
    
  /* ask for the speed of the transition */
  IF(effectShapes <> "NONE") THEN
  DO
    arraySpeed = .array~of("SLOW", "MEDIUM", "FAST")
    speedShape = .bsf.dialog~inputBox("Choose the speed of the shape "-
      "animation!", "Effects", "question", , arraySpeed)
    IF(speedShape == .nil) THEN
      EXIT 0
  END
END

/* ask for end-slide and autmatic start of the presentation */
addEndSlide = .bsf.dialog~dialogBox("Should a 'Thank you for your attention'"-
  "slide be generated?", "Question", "question", "YesNo")

runPresentation = .bsf.dialog~dialogbox("Do you want to start the "-
 "presentation after adding the new slide?", "Question", "question", "YesNo")

IF (addEndSlide == 0) THEN
  DO
    /* insert a slide at the end of the presentation */
    xDrawPages~insertNewByIndex(pagecount)
    lastPage = xDrawPages~getByIndex(pagecount)~XDrawPage

    /* create the heading of the last slide */
    textShape = xImpressFactory~createInstance("com.sun.star.drawing.TextShape") 
    textShape = textShape~XShape
    CALL setSizeAndPosition textShape, 22000, 2200, 2800, 7700
    textProps = textShape~XPropertySet
    lastPage~add(textShape)
    textProps~setPropertyValue("TextFitToSize",-
      bsf.getConstant("com.sun.star.drawing.TextFitToSizeType","PROPORTIONAL"))
    textShape~XText~setString("Thank you for your attention!")
  END

/* go through each slide */
DO i = 0 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  xShapes = xDrawPage~XShapes
/* go over each shape if wanted */
  IF(shapeAnimation == 0) THEN
    DO j = 0 TO xShapes~getCount - 1
       xShape = xShapes~getByIndex(j)
       xShapeProps = xShape~XPropertySet
       /* assigning effects, etc. */
       xShapeProps~setPropertyValue("Effect",-
         bsf.getConstant("com.sun.star.presentation.AnimationEffect",-
         effectShapes))
       IF(speedShape <> "SPEEDSHAPE") THEN
       xShapeProps~setPropertyValue("Speed",-
         bsf.getConstant("com.sun.star.presentation.AnimationSpeed",-
         speedShape))
    END
  xDrawPageProps = xDrawPage~XPropertySet
  IF (seconds == 0) THEN
    value = 0
  ELSE
    value = 1
  /* assigning effects, etc. */
  xDrawPageProps~setPropertyValue("Change", box("int", value))
  xDrawPageProps~setPropertyValue("Duration", box("int", seconds))
  xDrawPageProps~setPropertyValue("Effect", -
    bsf.getConstant("com.sun.star.presentation.FadeEffect", effect))
  IF(speed <> "SPEED") THEN
    xDrawPageProps~setPropertyValue("Speed", -
      bsf.getConstant("com.sun.star.presentation.AnimationSpeed", speed))
END

/* starting the presentation */
if(runPresentation == 0) THEN
  DO
    xPresentation = oDoc~XPresentationSupplier~getPresentation
    xPresentation~bsf.invoke("start")
  END

EXIT 0
SYNTAX:
   .bsf.dialog~messageBox("Error in line " SIGL ". Please check your input!",-
     "ERROR", "error")

::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	