/* This macro generates a guidepost section on the left side of each
   page. It shows all the heading 1 textshapes on it and marks the
   current position */
/* 07_guideposts.rex */

xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages
/* global service manager for shape grouper */
xContext = xScriptContext~getComponentContext
XMcf = xContext~getServiceManager
CALL removeSelection oDoc
/* check pagecount */
CALL getNumberOfVisibleSlides xDrawPages
pagecount = result

IF pagecount == 1 THEN
DO
  .bsf.dialog~messageBox("This presentation has only one slide. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

firstDrawPageProps = xDrawPages~getByIndex(0)~XDrawPage~XPropertySet
height = firstDrawPageProps~getPropertyValue("Height")

/* ask for end-slide, the slide will get no guideposts */
hasEndSlide = .bsf.dialog~dialogBox("Is there an end-slide in "-
  "this presentation?", "Question", "question", "YesNo")
headlineName = getHeadlineDisplayName(oDoc, "headline")
headline1Name = getHeadlineDisplayName(oDoc, "headline1")
/* create array with index and title of each heading-slide */
headingIndex = .array ~new
counter = 0
startIndex = 0
pagecount=xDrawPages~XIndexAccess~getCount 
DO i = 0 TO pagecount - 1  
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  
  /* remove existing guideposts, if necessary */
  xShapes = xDrawPage~XShapes
  IF(xShapes~getCount > 0) THEN
    DO j = 0 TO xShapes~getCount - 1
       xShape = xShapes~getByIndex(j)
       IF(xShape~XNamed~getName() == "guidepost_group") THEN
       DO
          xShapeGroup = xShape~XShapeGroup
          xDrawPage~remove(xShapeGroup)
       END
    END
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 1) THEN
  DO j = 0 TO xShapes~getCount - 1
     xShape = xShapes~getByIndex(j)
     xShapeProps = xShape~XPropertySet
     style = xShapeProps~getPropertyValue("Style")
     styleProps = style~XPropertySet
     nameStyle = styleProps~getPropertyValue("DisplayName")
     IF(xShape~XText == .nil) THEN
        ITERATE
     text = xShape~XText~getString()
     /* if the style is heading */
     IF (nameStyle == headlineName) THEN
     DO
        IF (startIndex == 0) THEN
           startIndex = i
        headingIndex~put(i||":"||"1:"||text, counter+1)
        counter = counter + 1
     END
     IF (nameStyle == headline1Name) THEN
     DO
        IF (startIndex == 0) THEN
           startIndex = i
        headingIndex~put(i||":"||"2:"||text, counter+1)
        counter = counter + 1
     END
  END
END

/* there are no heading slides */
IF counter == 0 THEN
DO
  .bsf.dialog~messageBox("This presentation has no heading textfields. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

IF hasEndSlide = 0 THEN
  endIndex = pagecount - 2
ELSE
  endIndex = pagecount - 1

stepY = trunc((height - 3000) / counter)
posY = 3000
DO i = startIndex TO endIndex
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    /* creating and positioning of left rectangle with the guideposts */
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 0) THEN
    ITERATE
  rectangle = xImpressFactory~createInstance(-
    "com.sun.star.drawing.RectangleShape") 
  rectangle = rectangle~XShape
  CALL setSizeAndPosition rectangle, 6000, height, 50, 50
  rectangleProps=rectangle~XPropertySet
  rectangleProps~setPropertyValue("FillColor", box("int", "BABED6"x ~c2d))
  rectangleProps~setPropertyValue("LineStyle",-
    bsf.getConstant("com.sun.star.drawing.LineStyle", "NONE"))
  xDrawPage~add(rectangle)

  /* create the group */
  shapeGroup = xMcf~createInstanceWithContext(-
    "com.sun.star.drawing.ShapeCollection", xContext)
  shapeGroup = shapeGroup~XShapes
  shapeGroup~add(rectangle)  

  posY = 3000
  counter = 1
  marked = 0
  /* adding the headings to the rectangle and mark the correct heading */
  DO item OVER headingIndex
    PARSE VAR item id":"level":"textGuidePost
    nextItem = headingIndex[counter+1]
    PARSE VAR nextItem nextIndex ":"

    textShape = xImpressFactory~createInstance(-
      "com.sun.star.drawing.TextShape") 
    textShape = textShape~XShape
  
    textProps = textShape~XPropertySet
    xDrawPage~add(textShape)
    shapeGroup~add(textShape)
    textShape~XText~setString(textGuidePost)
    IF(counter <= i & i < nextIndex & marked == 0) THEN
    DO
      textProps~setPropertyValue("CharColor",  box("int", "FF0000"x ~c2d))
      marked = 1
    END
    ELSE
      textProps~setPropertyValue("CharColor",  box("int", "000000"x ~c2d))
    counter = counter + 1
    padding = 0
    IF(level == 1) THEN
      textProps~setPropertyValue("CharHeight", box("float", 26))
    ELSE
      DO
        textProps~setPropertyValue("CharHeight", box("float", 20))
        padding = 600
      END
    CALL setSizeAndPosition textShape, 5400, 1200, 300 + padding, posY
    posY = posY + stepY
  END
  
  xShapeGrouper = xDrawPage~XShapeGrouper
  xShapeGroup = xShapeGrouper~group(shapeGroup)
  name = xShapeGroup~XNamed 
  name~setName("guidepost_group") 
END
EXIT 0

/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

getHeadlineDisplayName :
  oDoc = ARG(1)  
  progName = ARG(2)
  model= oDoc~XModel
  famSupplier = model~XStyleFamiliesSupplier
  families = famSupplier~getStyleFamilies()
  graphs = families~getByName("graphics")
  styles = graphs~XNameAccess
  titelStyle = styles~getByName(progName)
  styleProps = titelStyle~XPropertySet
  RETURN styleProps~getPropertyValue("DisplayName")
  
::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	
 
/* routine for removing selection*/
::routine  removeSelection
  use arg oDoc 

  model= oDoc~XModel
  controller = model~getCurrentController()
  selectionController = controller~XSelectionSupplier
  selected = selectionController~getSelection()
  selectionController~select(.nil)