/* This macro does exactly the same as 07_guideposts, but displays the 
   headings in form of circles on the slides and marks it */
/* 08_guideposts_circles.rex */

xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages
/* global service manager for shape grouper */
xContext = xScriptContext~getComponentContext
XMcf = xContext~getServiceManager
CALL removeSelection oDoc
/* check pagecount */
CALL getNumberOfVisibleSlides xDrawPages
pagecount = result


IF pagecount == 1 THEN
DO
  .bsf.dialog~messageBox("This presentation has only one slide. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

firstDrawPageProps = xDrawPages~getByIndex(0)~XDrawPage~XPropertySet
height = firstDrawPageProps~getPropertyValue("Height")

/* ask for end-slide, the slide will get no guideposts */
hasEndSlide = .bsf.dialog~dialogBox("Is there an end-slide in "-
  "this presentation?", "Question", "question", "YesNo")
headlineName = getHeadlineDisplayName(oDoc)
/* create array with index and title of each heading-slide */
headingIndex = .array ~new
counter = 0
startIndex = 0
pagecount=xDrawPages~XIndexAccess~getCount 
DO i = 0 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  /* remove existing guideposts, if necessary */
  xShapes = xDrawPage~XShapes
  IF(xShapes~getCount > 0) THEN
    DO j = 0 TO xShapes~getCount - 1
       xShape = xShapes~getByIndex(j)
       IF(xShape~XNamed~getName() == "guidepost_group") THEN
       DO
          xShapeGroup = xShape~XShapeGroup
          xDrawPage~remove(xShapeGroup)
       END
    END
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 1) THEN
  DO j = 0 TO xShapes~getCount - 1
     xShape = xShapes~getByIndex(j)
     xShapeProps = xShape~XPropertySet
     style = xShapeProps~getPropertyValue("Style")
     styleProps = style~XPropertySet
     nameStyle = styleProps~getPropertyValue("DisplayName")
     IF(xShape~XText == .nil) THEN
       ITERATE
     text = xShape~XText~getString()
     /* if the style is heading */
     IF (nameStyle == headlineName) THEN
     DO
        IF (startIndex == 0) THEN
          startIndex = i
        /* assign bookmark to each heading page */
        xPageName = xDrawPage~XNamed 
        xPageName~setName(i)
        headingIndex~put(i, counter+1)
        counter = counter + 1
     END
  END
END

/* there are no heading slides */
IF counter == 0 THEN
DO
  .bsf.dialog~messageBox("This presentation has no heading textfields. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

IF hasEndSlide = 0 THEN
  endIndex = pagecount - 2
ELSE
  endIndex = pagecount - 1

stepY = trunc((height - 3000) / counter)
posY = 3000
countHeadings = counter
DO i = startIndex TO endIndex
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 0) THEN
    ITERATE
  posY = 3000
  counter = 1
  marked = 0
  /* create the group */
  shapeGroup = xMcf~createInstanceWithContext(-
    "com.sun.star.drawing.ShapeCollection", xContext)
  shapeGroup = shapeGroup~XShapes

  DO itemId OVER headingIndex
    nextIndex = headingIndex[counter+1]
    IF (countHeadings <> counter) THEN 
    DO
      /* adding the lines between the heading circles till the last guidepost */
      rectangle = xImpressFactory~createInstance(-
        "com.sun.star.drawing.RectangleShape") 
      rectangle = rectangle~XShape
      CALL setSizeAndPosition rectangle, 300, stepY - 1000, 1360, posY + 1300
      rectangleProps=rectangle~XPropertySet
      IF (nextIndex <= i) THEN
	rectangleProps~setPropertyValue("FillColor", box("int", "FF0000"x ~c2d))
      ELSE 
        rectangleProps~setPropertyValue("FillColor",-
          box("int", "000000"x ~c2d))
      xDrawPage~add(rectangle)
      shapeGroup~add(rectangle) 
    END

    /* create the circles with the heading serial number */
    point = xImpressFactory~createInstance(-
      "com.sun.star.drawing.EllipseShape") 
    point = point~XShape
    pointProps=point~XPropertySet
    constant = bsf.getConstant("com.sun.star.drawing.CircleKind", "FULL")
    pointProps~setPropertyValue("CircleKind", constant)
    pointProps~setPropertyValue("FillColor", box("int", "FFFF00"x ~c2d))
    CALL setSizeAndPosition point, 1400, 1400, 800, posY
    xDrawPage~add(point)
    shapeGroup~add(point)      

    /* set the click event to the bookmark of the corresponding heading */
    pointProps~setPropertyValue("OnClick", -
      bsf.getConstant("com.sun.star.presentation.ClickAction","BOOKMARK"))
    pointProps~setPropertyValue("Bookmark", itemId)
    point~XText~setString(counter)
    posY = posY + stepY

    IF(counter <= i & i < nextIndex & marked == 0) THEN
    DO
      pointProps~setPropertyValue("CharColor",  box("int", "FF0000"x ~c2d))
      marked = 1
    END
    ELSE
      pointProps~setPropertyValue("CharColor",  box("int", "000000"x ~c2d))
    counter = counter + 1
  END
  xShapeGrouper = xDrawPage~XShapeGrouper
  xShapeGroup = xShapeGrouper~group(shapeGroup)
  name = xShapeGroup~XNamed 
  name~setName("guidepost_group") 
END
EXIT 0

/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

getHeadlineDisplayName :
  oDoc = ARG(1)  
  model= oDoc~XModel
  famSupplier = model~XStyleFamiliesSupplier
  families = famSupplier~getStyleFamilies()
  graphs = families~getByName("graphics")
  styles = graphs~XNameAccess
  titelStyle = styles~getByName("headline")
  styleProps = titelStyle~XPropertySet
  RETURN styleProps~getPropertyValue("DisplayName")
  
::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* routine for positioning and resizing a shape */
::routine  setSizeAndPosition
  use arg shape, width, height, posX, posY

  shape~setSize(-
    .bsf~new("com.sun.star.awt.Size", width, height))
  shape~setPosition(.bsf~new("com.sun.star.awt.Point", posX, posY))	

/* routine for removing selection*/
::routine  removeSelection
  use arg oDoc

  model= oDoc~XModel
  controller = model~getCurrentController()
  selectionController = controller~XSelectionSupplier
  selected = selectionController~getSelection()
  selectionController~select(.nil)