/* This macro creates automatically an agenda of the presentation
   using the heading1 textfields */
/* 09_agenda.rex */

xScriptContext=uno.getScriptContext()  -- get the xScriptContext object
oDoc=xScriptContext~getDocument  -- get the document service (an XModel object)
/* retrieving the important interfaces to get access to the drawpages */
xDrawPagesSupplier=oDoc~XDrawPagesSupplier
xImpressFactory = oDoc~XMultiServiceFactory
xDrawPages = xDrawPagesSupplier~getDrawPages

/* check pagecount */
CALL getNumberOfVisibleSlides xDrawPages
pagecount = result
IF pagecount == 1 THEN
DO
  .bsf.dialog~messageBox("This presentation has only one slide. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END
headlineName = getHeadlineDisplayName(oDoc)
/* create array with index and title of each heading-slide */
headingIndex = .array ~new
counter = 0
startIndex = 0
pagecount=xDrawPages~XIndexAccess~getCount 
DO i = 0 TO pagecount - 1
  xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
  xProps = xDrawPage~XPropertySet
  IF(xProps~getPropertyValue("Visible") == 0) THEN
    ITERATE
  xShapes = xDrawPage~XShapes
  DO j = 0 TO xShapes~getCount - 1
     xShape = xShapes~getByIndex(j)
     xShapeProps = xShape~XPropertySet
     style = xShapeProps~getPropertyValue("Style")
     styleProps = style~XPropertySet
     nameStyle = styleProps~getPropertyValue("DisplayName")
     IF(xShape~XText == .nil) THEN
       ITERATE
     text = xShape~XText~getString()
     /* if the style is heading */
     IF (nameStyle == headlineName) THEN
     DO
        IF (startIndex == 0) THEN
           startIndex = i
        headingIndex~put(i||":"||text, counter+1)
        counter = counter + 1
     END
  END
END

/* there are no heading slides */
IF counter == 0 THEN
DO
  .bsf.dialog~messageBox("This presentation has no heading textfields. "-
    "There is no need for running this macro!", "ERROR", "error")
  EXIT 0
END

/* if there is no existing agenda insert a new drawpage */
secondSlide = xDrawPages~getByIndex(1)~XDrawPage
nameSecondSlide = secondSlide~XNamed 
IF (nameSecondSlide~getName() <> "agenda") THEN
DO
  xDrawPages~insertNewByIndex(0)
END

/* format the agenda slide */
agendaPage = xDrawPages~getByIndex(1)~XDrawPage
CALL prepareAgendaSlide agendaPage

/* positioning of the text cursor */
headingListShape = agendaPage~XShapes
headingListShape = headingListShape~getByIndex(1)
xText = headingListShape~XText
xText~setString("")
xTextCursor = xText~createTextCursor
xTextCursor~gotoEnd(.false)
xTextRange = xTextCursor~XTextRange

linebreak = "0d0a"x
start = 0

DO item OVER headingIndex
  PARSE VAR item id":"text 
  /* adding the headings to the listing */
  IF (start == 1) THEN
    xTextRange~setString(linebreak||text)
  ELSE
  DO
    xTextRange~setString(text)
    start = 1
  END  
  xTextCursor~gotoEnd(.false)
  xTextRange = xTextCursor~XTextRange
END

/* format the listing */
CALL formatAgenda headingListShape
EXIT 0

/* Returns the number of visible slides */
getNumberOfVisibleSlides :
  USE ARG xDrawPages
  count = 0
  pagecount=xDrawPages~XIndexAccess~getCount
  DO i = 0 TO pagecount - 1
    xDrawPage = xDrawPages~getByIndex(i)~XDrawPage
    xProps = xDrawPage~XPropertySet
    IF(xProps~getPropertyValue("Visible") == 1) THEN
      count = count + 1
  END
return count

getHeadlineDisplayName :
  oDoc = ARG(1)  
  model= oDoc~XModel
  famSupplier = model~XStyleFamiliesSupplier
  families = famSupplier~getStyleFamilies()
  graphs = families~getByName("graphics")
  styles = graphs~XNameAccess
  titelStyle = styles~getByName("headline")
  styleProps = titelStyle~XPropertySet
  RETURN styleProps~getPropertyValue("DisplayName")
  
::requires UNO.CLS   -- load UNO support for OpenOffice.org

/* procedure for formating the agenda slide */
/* assigning of layout and heading */
::routine  prepareAgendaSlide
  use arg agendaPage

  xPageName = agendaPage~XNamed 
  xPageName~setName("agenda")
  agendaPageProps = agendaPage~XPropertySet
  agendaPageProps~setPropertyValue("Layout", box("short", 1))

  xShapes = agendaPage~XShapes
  agendaHeadingShape = xShapes~getByIndex(0)
  xText = agendaHeadingShape~XText
  xText~setString("Agenda")

/* procedure for formating the listing */
/* increasing of line spacing and fontsize */
::routine formatAgenda
  use arg agendaShape

  headingListShapeProsp = agendaShape~XPropertySet
  lineSpacing = headingListShapeProsp~getPropertyValue("ParaLineSpacing")
  lineSpacing~Height=500
  lineSpacing~Mode=2
  headingListShapeProsp~setPropertyValue("ParaLineSpacing", lineSpacing)
  headingListShapeProsp~setPropertyValue("CharHeight", box("float", 40))
