-- [8][BSF][Rexx]
-- Save current text document in Word 97 format

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- ---------- End of connection header ---------------

-- [8][BSF][Rexx]
-- Save current text document in Word 97 format

-- Pasted code of script #4: Open a blank text document

propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)

xWriterComponent = xComponentLoader~loadComponentFromURL( ,
	"private:factory/swriter", "_blank", 0, loadProps)

-- End code of script #4

-- Get a "Storable" interface in the context of the Writer application
xStorableName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XStorable")
xStorable = unoRuntime~queryInterface(xStorableName, xWriterComponent)

-- This time we need to define a property: The filter name
propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
storeProps = .bsf~createArray(propertyValueName, 1)
storeProps[1] = .bsf~new("com.sun.star.beans.PropertyValue")
storeProps[1]~bsf.setFieldValue("Name", "FilterName")
storeProps[1]~bsf.setFieldValue("Value", "MS Word 97")

storeUrl = "file:///c:/test.doc"	-- Linux/UNIX users change the filename!
xStorable~storeAsURL(storeUrl, storeProps)


::requires "BSF.cls"