-- [10][BSF][Rexx]
-- Print a text document

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- ---------- End of connection header ---------------

-- Pasted code of script #4: Open a blank text document

propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)

xWriterComponent = xComponentLoader~loadComponentFromURL( ,
	"private:factory/swriter", "_blank", 0, loadProps)

-- End code of script #4

-- [10][BSF][Rexx]
-- Print a text document

-- Get a "Printable" interface in the context of the Writer application
xPrintableName = .bsf4rexx~Class.class~forName("com.sun.star.view.XPrintable")
xPrintable = unoRuntime~queryInterface(xPrintableName, xWriterComponent)

-- We need to define a property: The printer name
-- This is a printer's name as known in your system.
propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
printerDesc = .bsf~createArray(propertyValueName, 1)
printerDesc[1] = .bsf~new("com.sun.star.beans.PropertyValue")
printerDesc[1]~bsf.setFieldValue("Name", "Name")
printerDesc[1]~bsf.setFieldValue("Value", "HP PSC 950")  -- Change this to your printer name!
xPrintable~setPrinter(printerDesc)

-- Print options are properties, too.
-- We want to define which pages to print
printOpts = .bsf~createArray(propertyValueName, 1)
printOpts[1] = .bsf~new("com.sun.star.beans.PropertyValue")
printOpts[1]~bsf.setFieldValue("Name", "Pages")
printOpts[1]~bsf.setFieldValue("Value", "1")

-- This prints the (empty) test page
xPrintable~print(printOpts);


::requires "BSF.cls"