-- [12][BSF][Rexx]
-- Object Rexx connection header for spreadsheet examples

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- Open a blank spreadsheet document
-- If you wish to open an existing document, use a different URL (see chapter 2.1.1.2)
-- You can address single sheets in your existing document by indicating a different 
-- index number (see below "oIndexSheets~getByIndex(0)").

propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)	-- We need no properties
xSheetComponent = ,
	xComponentLoader~loadComponentFromURL("private:factory/scalc", "_blank", 0, loadProps)
xSpreadsheetDocumentName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheetDocument")
xDocument = unoRuntime~queryInterface(xSpreadsheetDocumentName, xSheetComponent)
xSheets = xDocument~getSheets

xIndexAccessName = .bsf4rexx~Class.class~forName("com.sun.star.container.XIndexAccess")
xIndexSheets = unoRuntime~queryInterface(xIndexAccessName, xSheets)
xSheetName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheet")
xSheet = unoRuntime~queryInterface(xSheetName, xIndexSheets~getByIndex(0))

-- Ready for action ...


::requires "BSF.cls"