-- [18][BSF][Rexx]
-- A function to calculate the average not considering empty fields

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- Open a blank spreadsheet document
-- If you wish to open an existing document, use a different URL (see chapter 2.1.1.2)
-- You can address single sheets in your existing document by indicating a different 
-- index number (see below "oIndexSheets~getByIndex(0)").

propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)	-- We need no properties
xSheetComponent = ,
	xComponentLoader~loadComponentFromURL("private:factory/scalc", "_blank", 0, loadProps)
xSpreadsheetDocumentName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheetDocument")
xDocument = unoRuntime~queryInterface(xSpreadsheetDocumentName, xSheetComponent)
xSheets = xDocument~getSheets

xIndexAccessName = .bsf4rexx~Class.class~forName("com.sun.star.container.XIndexAccess")
xIndexSheets = unoRuntime~queryInterface(xIndexAccessName, xSheets)
xSheetName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheet")
xSheet = unoRuntime~queryInterface(xSheetName, xIndexSheets~getByIndex(0))

-- ---------- End of connection header ---------------

-- [18][BSF][Rexx]
-- A function to calculate the average not considering empty fields

-- Test for function avgNonEmpty:

-- (1) Insert dummy data
call insert 0, 0, 5.2, xSheet, 1
call insert 0, 2, 2.3, xSheet, 1

-- (2) Calculate and print average
result = avgNonEmpty(0, 0, 0, 2, xSheet)
call insert 0, 3, result, xSheet, 1

-- (3) Insert some labels
call insert 1, 1, "<- Remains empty", xSheet, 0
call insert 1, 3, "<- The average", xSheet, 0

EXIT

-- A function to calculate the average not considering empty fields
avgNonEmpty: PROCEDURE
use arg fromx, fromy, tox, toy, container
	sum = 0
	fieldCount = 0

	do i=fromx to tox
		do j=fromy to toy
			currentValue = container~getCellByPosition(i, j) ~getValue 
			if currentValue <> "0.0" then
			do
				sum = sum + currentValue
				fieldCount = fieldCount + 1
			end
		end
	end

	if fieldCount > 0 then
		RETURN (sum/fieldCount)
	else
		RETURN 0

-- ----------------------------------------------------
-- The insert function (from example #13)
insert: PROCEDURE
use arg x, y, content, container, isValue
	oCell = container~getCellByPosition(x, y)
	if isValue then
		oCell~setValue(.bsf~new("java.lang.Float", content) ~floatValue)
	else
		oCell~setFormula(content)
	RETURN


::requires "BSF.cls"