-- [20][BSF][Rexx]
-- Cell formatting

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- Open a blank spreadsheet document
-- If you wish to open an existing document, use a different URL (see chapter 2.1.1.2)
-- You can address single sheets in your existing document by indicating a different 
-- index number (see below "oIndexSheets~getByIndex(0)").

propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)	-- We need no properties
xSheetComponent = ,
	xComponentLoader~loadComponentFromURL("private:factory/scalc", "_blank", 0, loadProps)
xSpreadsheetDocumentName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheetDocument")
xDocument = unoRuntime~queryInterface(xSpreadsheetDocumentName, xSheetComponent)
xSheets = xDocument~getSheets

xIndexAccessName = .bsf4rexx~Class.class~forName("com.sun.star.container.XIndexAccess")
xIndexSheets = unoRuntime~queryInterface(xIndexAccessName, xSheets)
xSheetName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheet")
xSheet = unoRuntime~queryInterface(xSheetName, xIndexSheets~getByIndex(0))

-- ---------- End of connection header ---------------

-- [20][BSF][Rexx]
-- Cell formatting

-- Insert some dummy data
do i=0 to 3
	do j=0 to 3
		call insert i, j, i*j, xSheet, 1
	end
end

-- Set style
xStyleFamiliesSupplierName = .bsf4rexx~Class.class~forName("com.sun.star.style.XStyleFamiliesSupplier")
xStyleFamiliesSupplier = unoRuntime~queryInterface(xStyleFamiliesSupplierName, xDocument)
xStyleFamilies = xStyleFamiliesSupplier~getStyleFamilies
xNameAccessName = .bsf4rexx~Class.class~forName("com.sun.star.container.XNameAccess")
xCellStyles = unoRuntime~queryInterface(xNameAccessName, xStyleFamilies~getByName("CellStyles"))
xDocumentMultiServiceFactoryName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xDocumentMultiServiceFactory = unoRuntime~queryInterface(xDocumentMultiServiceFactoryName, xDocument)
oStyleFamilyNameContainerName = .bsf4rexx~Class.class~forName("com.sun.star.container.XNameContainer")
oStyleFamilyNameContainer = unoRuntime~queryInterface(oStyleFamilyNameContainerName, xCellStyles)
style = xDocumentMultiServiceFactory~createInstance("com.sun.star.style.CellStyle")
oStyleFamilyNameContainer~insertByName("My Style", style)

oCellProperties1Name = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
oCellProperties1 = unoRuntime~queryInterface(oCellProperties1Name, style)
oCellProperties1~setPropertyValue( , 
	"IsCellBackgroundTransparent", .bsf~new("java.lang.Boolean", false))
oCellProperties1~setPropertyValue( ,
	"CellBackColor", .bsf~new("java.lang.Integer", 6710932))   -- = hex 66 66 94
oCellProperties1~setPropertyValue( ,
	"CharColor", .bsf~new("java.lang.Integer", 16777215))      -- = hex FF FF FF

-- Apply the defined style to a cell range (cells 0/0 to 3/3 = A1:C4)
cellRange = xSheet~getCellRangeByPosition(0, 0, 3, 3)

-- get existing properties of cells in range
cellPropertiesName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
cellProperties = unoRuntime~queryInterface(cellPropertiesName, cellRange)

-- redefine properties of cells in range
--  !! Note for Rexx users: You must point BSF4Rexx to the right method
--     using the invokeStrict function with type indicators ("ST" for String)
cellProperties~bsf.invokeStrict("setPropertyValue", "ST", "CellStyle", "ST", "My Style")

EXIT

-- ----------------------------------------------------
-- The insert function (from example #13)
insert: PROCEDURE
use arg x, y, content, container, isValue
	oCell = container~getCellByPosition(x, y)
	if isValue then
		oCell~setValue(.bsf~new("java.lang.Float", content) ~floatValue)
	else
		oCell~setFormula(content)
	RETURN


::requires "BSF.cls"