-- [22][BSF][Rexx]
-- Create a chart in a spreadsheet

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- Open a blank spreadsheet document
-- If you wish to open an existing document, use a different URL (see chapter 2.1.1.2)
-- You can address single sheets in your existing document by indicating a different 
-- index number (see below "oIndexSheets~getByIndex(0)").

propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)	-- We need no properties
xSheetComponent = ,
	xComponentLoader~loadComponentFromURL("private:factory/scalc", "_blank", 0, loadProps)
xSpreadsheetDocumentName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheetDocument")
xDocument = unoRuntime~queryInterface(xSpreadsheetDocumentName, xSheetComponent)
xSheets = xDocument~getSheets

xIndexAccessName = .bsf4rexx~Class.class~forName("com.sun.star.container.XIndexAccess")
xIndexSheets = unoRuntime~queryInterface(xIndexAccessName, xSheets)
xSheetName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XSpreadsheet")
xSheet = unoRuntime~queryInterface(xSheetName, xIndexSheets~getByIndex(0))

-- ---------- End of connection header ---------------

-- [22][BSF][Rexx]
-- Create a chart in a spreadsheet

-- As a prerequisite, we populate the spreadsheet with some numeric values:
do i=0 to 4
	do j=0 to 3
		call insert i, j, i+j, xSheet, 1
	end
end

-- First create the elements the chart consists of:
-- (1) a frame (made from the Rectangle class)
oRect = .bsf~new("com.sun.star.awt.Rectangle")
oRect~bsf.setFieldValue("X", 500)
oRect~bsf.setFieldValue("Y", 3000)
oRect~bsf.setFieldValue("Width", 25000)
oRect~bsf.setFieldValue("Height", 11000)

-- (2) the underlying data (the numeric values come from a cell range)
xCellRangeName = .bsf4rexx~Class.class~forName("com.sun.star.table.XCellRange")
oRange = unoRuntime~queryInterface(xCellRangeName, xSheet)
myRange = oRange~getCellRangeByName("A1:E4")
xCellRangeAddressableName = .bsf4rexx~Class.class~forName("com.sun.star.sheet.XCellRangeAddressable")
oRangeAddr = unoRuntime~queryInterface(xCellRangeAddressableName, myRange)

-- Now get the chart collection from the Sheet's charts supplier and add a new chart

-- Get the address of the underlying data (in our case a cell range)
myAddr = oRangeAddr~getRangeAddress
cellRangeAddressName = .bsf4rexx~Class.class~forName("com.sun.star.table.CellRangeAddress")
oAddr = .bsf~createArray(cellRangeAddressName, 1)
oAddr[1] = myAddr
-- Get the supplier and its charts
xTableChartsSupplierName = .bsf4rexx~Class.class~forName("com.sun.star.table.XTableChartsSupplier")
oSupp = unoRuntime~queryInterface(xTableChartsSupplierName, xSheet)
oCharts = oSupp~getCharts
-- Append a new chart to the collection
oCharts~addNewByName("Example", oRect, oAddr, true, true)

-- change diagram properties: 2-D to 3-D
xNameAccessName = .bsf4rexx~Class.class~forName("com.sun.star.container.XNameAccess")
tempName = unoRuntime~queryInterface(xNameAccessName, oCharts) ~getByName("Example")
xTableChartName = .bsf4rexx~Class.class~forName("com.sun.star.table.XTableChart")
oChart = unoRuntime~queryInterface(xTableChartName , tempName)
xEmbeddedObjectSupplierName = .bsf4rexx~Class.class~forName("com.sun.star.document.XEmbeddedObjectSupplier")
oInt = unoRuntime~queryInterface(xEmbeddedObjectSupplierName, oChart) ~getEmbeddedObject
xChartDocumentName = .bsf4rexx~Class.class~forName("com.sun.star.chart.XChartDocument")
oDiag = unoRuntime~queryInterface(xChartDocumentName, oInt) ~getDiagram

-- change diagram to 3-D
xPropertySetName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
oCPS = unoRuntime~queryInterface(xPropertySetName, oDiag)
oCPS~setPropertyValue("Dim3D", .bsf~new("java.lang.Boolean", true))

EXIT

-- ----------------------------------------------------
-- The insert function (from example #13)
insert: PROCEDURE
use arg x, y, content, container, isValue
	oCell = container~getCellByPosition(x, y)
	if isValue then
		oCell~setValue(.bsf~new("java.lang.Float", content) ~floatValue)
	else
		oCell~setFormula(content)
	RETURN


::requires "BSF.cls"