-- [24][BSF][Rexx]
-- Text manipulation

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- ---------- End of connection header ---------------

-- [24][BSF][Rexx]
-- Text manipulation

-- Open a blank text document
propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)	-- We need no properties
xWriterComponent = xComponentLoader~loadComponentFromURL("private:factory/swriter", "_blank", 0, loadProps)

-- Get the document's text interface
xTextDocumentName = .bsf4rexx~Class.class~forName("com.sun.star.text.XTextDocument")
xTextDocument = unoRuntime~queryInterface(xTextDocumentName, xWriterComponent)
xText = xTextDocument~getText

-- Now we could start writing into the document, for example:
-- xText~setString("A few words ...")

-- In order to set paragraph properties, we need a cursor for navigation.
-- A cursor can be retrieved from the controller,
-- the controller comes from the model,
-- and the model comes from the component, i.e. the application.

-- Get model from component
xModelName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XModel")
xModel = unoRuntime~queryInterface(xModelName, xWriterComponent)

-- The model knows its controller
xController = xModel~getCurrentController

-- The controller gives us the TextViewCursor
-- Query the viewcursor supplier interface 
xTextViewCursorSupplierName = .bsf4rexx~Class.class~forName("com.sun.star.text.XTextViewCursorSupplier")
xViewCursorSupplier = unoRuntime~queryInterface(xTextViewCursorSupplierName, xController)

-- Get the cursor 
xViewCursor = xViewCursorSupplier~getViewCursor

-- Set the appropriate property for paragraph style
xPropertySetName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
xCursorPropertySet = unoRuntime~queryInterface(xPropertySetName, xViewCursor)
--  !! Note for Rexx users: You must point BSF4Rexx to the right method
--     using the invokeStrict function with type indicators ("ST" for String)
xCursorPropertySet~bsf.invokeStrict("setPropertyValue", "ST", "ParaStyleName", "ST", "Quotations")

-- Print the current page number  we need the XPageCursor interface for this
xPageCursorName = .bsf4rexx~Class.class~forName("com.sun.star.text.XPageCursor")
xPageCursor = unoRuntime~queryInterface(xPageCursorName, xViewCursor)

-- This is written directly into the open document (see above).
xText~setString("The current page number is " xPageCursor~getPage)

-- If we had not retrieved the text interface from the xTextDocument (see above),
-- we could now get it from the TextViewCursor.
-- The cursor is an XTextRange and has therefore a method getText():
-- xDocumentText = xViewCursor~getText

-- The text creates a model cursor from the viewcursor
xModelCursor = xText~createTextCursorByRange(xViewCursor~getStart)

-- Now we could query XWordCursor, XSentenceCursor and XParagraphCursor
-- or XDocumentInsertable, XSortable or XContentEnumerationAccess
-- and work with the properties of com.sun.star.text.TextCursor

-- In this case we just go to the end of the paragraph and add some text.
-- Now get a paragraph cursor first.
xParagraphCursorName = .bsf4rexx~Class.class~forName("com.sun.star.text.XParagraphCursor")
xParagraphCursor = unoRuntime~queryInterface(xParagraphCursorName, xModelCursor)

-- Go to the end of the paragraph
xParagraphCursor~gotoEndOfParagraph(false)
xParagraphCursor~setString(" ***** Fin de semana! ******")


::requires "BSF.cls"