-- [26][BSF][Rexx]
-- Draw an organigram

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- ---------- End of connection header ---------------

-- [26][BSF][Rexx]
-- Draw an organigram

-- Open the "sdraw" application
propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
loadProps = .bsf~createArray(propertyValueName, 0)	-- We need no properties
xDrawComponent = xComponentLoader~loadComponentFromURL("private:factory/sdraw", "_blank", 0, loadProps)

-- Get draw page by index 
xDrawPagesSupplierName = .bsf4rexx~Class.class~forName("com.sun.star.drawing.XDrawPagesSupplier")
xDrawPagesSupplier = unoRuntime~queryInterface(xDrawPagesSupplierName, xDrawComponent)
xDrawPages = xDrawPagesSupplier~getDrawPages
drawPage = xDrawPages~getByIndex(0)
xDrawPageName = .bsf4rexx~Class.class~forName("com.sun.star.drawing.XDrawPage")
xDrawPage = unoRuntime~queryInterface(xDrawPageName, drawPage)

-- Find out page dimensions 
xPropertySetName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
xPageProps = unoRuntime~queryInterface(xPropertySetName, xDrawPage)
pageWidth = xPageProps~getPropertyValue("Width")
pageHeight = xPageProps~getPropertyValue("Height")
pageBorderTop = xPageProps~getPropertyValue("BorderTop")
pageBorderLeft = xPageProps~getPropertyValue("BorderLeft")
pageBorderRight = xPageProps~getPropertyValue("BorderRight")
drawWidth = pageWidth - pageBorderLeft - pageBorderRight
horCenter = pageBorderLeft + drawWidth / 2

-- Make up some data for organigram 
orgUnits.1.1 = "Management" -- level 0 
orgUnits.2.1 = "Production"
orgUnits.2.2 = "Purchasing"
orgUnits.2.3 = "IT Services"
orgUnits.2.4 = "Sales"    -- level 1 
levelCount.1 = 1
levelCount.2 = 4

-- Calculate shape, sizes and positions 
horSpace = 300
verSpace = 3000
shapeWidth = (drawWidth - (levelCount.2 - 1) * horSpace) / levelCount.2
shapeHeight = pageHeight / 20
shapeX = pageWidth / 2 - shapeWidth / 2
levelY = 0
xStartShape = .nil

-- Get document factory 

xMultiServiceFactoryName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xDocumentFactory = unoRuntime~queryInterface(xMultiServiceFactoryName, xDrawComponent)

-- Creating and adding RectangleShapes and Connectors         
do level=1 to 2
	levelY = pageBorderTop + 2000 + level * (shapeHeight + verSpace)

	do i=levelCount.level to 1 by -1
		shapeX = horCenter - ,
				(levelCount.level * shapeWidth + (levelCount.level - 1) * ,
				horSpace) / 2 + ,
				(i-1) * shapeWidth + (i-1) * horSpace
		shape = xDocumentFactory~createInstance("com.sun.star.drawing.RectangleShape")

		xShapeName = .bsf4rexx~Class.class~forName("com.sun.star.drawing.XShape")
		xShape = unoRuntime~queryInterface(xShapeName, shape)
		shapeX = format(shapeX, , 0)

		xShape~setPosition(.bsf~new("com.sun.star.awt.Point", shapeX, levelY))
		shapeWidth = format(shapeWidth, , 0)
		shapeHeight = format(shapeHeight, , 0)
		xShape~setSize(.bsf~new("com.sun.star.awt.Size", shapeWidth, shapeHeight))
		xDrawPage~add(xShape)

		-- Set the text 
		xTextName = .bsf4rexx~Class.class~forName("com.sun.star.text.XText")
		xText = unoRuntime~queryInterface(xTextName, xShape)
		xText~setString(orgUnits.level.i)

		-- Memorize the root shape, for connectors 
		if level = 1 & i = 1 then xStartShape = xShape

		-- Add connectors for level 1 
		if level = 2 then
		do
			connector = xDocumentFactory~createInstance("com.sun.star.drawing.ConnectorShape")
			xConnector = unoRuntime~queryInterface(xShapeName, connector)
			xDrawPage~add(xConnector)
			xConnectorProps = unoRuntime~queryInterface(xPropertySetName, connector)
			xConnectorProps~bsf.invokeStrict("setPropertyValue", "ST", "StartShape", "O", xStartShape)
			xConnectorProps~bsf.invokeStrict("setPropertyValue", "ST", "EndShape", "O", xShape)

			-- glue point positions: 0=top 1=left 2=bottom 3=right 
			xConnectorProps~setPropertyValue("StartGluePointIndex", .bsf~new("java.lang.Integer", 2))
			xConnectorProps~setPropertyValue("EndGluePointIndex", .bsf~new("java.lang.Integer", 0))
		end
	end
end


::requires "BSF.cls"