-- [28][BSF][Rexx]
-- Create a sample presentation

-- ---------- Begin of connection header ---------------

-- If your Open Office listens on another port than 8100,
-- change the following line.
unoUrl = "uno:socket,host=localhost,port=8100;urp;StarOffice.NamingService"

-- Load UNO Runtime for later use
unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")

-- Connect to Open Office
xComponentContext = .bsf~new("com.sun.star.comp.helper.Bootstrap") ~createInitialComponentContext(.nil)
xUrlResolver = xComponentContext~getServiceManager() ~createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", xComponentContext)

unoResolverName = .bsf4rexx~Class.class~forName("com.sun.star.bridge.XUnoUrlResolver")
urlResolver = unoRuntime~queryInterface(unoResolverName, xUrlResolver)

rInitialObject = urlResolver~resolve(unoUrl)
namingServiceName = .bsf4rexx~Class.class~forName("com.sun.star.uno.XNamingService")
rName = unoRuntime~queryInterface(namingServiceName, rInitialObject)

rXsmgr = rName~getRegisteredObject("StarOffice.ServiceManager")
msfName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
xMsf = unoRuntime~queryInterface(msfName, rXsmgr)

-- Retrieve the Desktop object, we need its XComponentLoader interface
-- to load a new document
oInterface = xMsf~createInstance("com.sun.star.frame.Desktop")
xDesktopName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XDesktop")
oDesktop = unoRuntime~queryInterface(xDesktopName, oInterface)
xComponentLoaderName = .bsf4rexx~Class.class~forName("com.sun.star.frame.XComponentLoader")
xComponentLoader = unoRuntime~queryInterface(xComponentLoaderName, oDesktop)

-- ---------- End of connection header ---------------

-- [28][BSF][Rexx]
-- Create a sample presentation

-- Open the "sdraw" application
propertyValueName = .bsf4rexx~Class.class~forName("com.sun.star.beans.PropertyValue") 
pPropValues = .bsf~createArray(propertyValueName, 1)

pPropValues[1] = .bsf~new("com.sun.star.beans.PropertyValue")
pPropValues[1]~bsf.setFieldValue("Name", "Silent")
pPropValues[1]~bsf.setFieldValue("Value", .bsf~new("java.lang.Boolean", true))

xDrawComponent = xComponentLoader~loadComponentFromURL("private:factory/simpress", "_blank", 0, pPropValues)

-- Create three presentation pages
xDrawPagesSupplierName = .bsf4rexx~Class.class~forName("com.sun.star.drawing.XDrawPagesSupplier")
xDrawPagesSupplier = unoRuntime~queryInterface(xDrawPagesSupplierName, xDrawComponent)
xDrawPages = xDrawPagesSupplier~getDrawPages

do 3
	xDrawPages~insertNewByIndex(0)
end

-- Set the slide transition for the first page
xDrawPageName = .bsf4rexx~Class.class~forName("com.sun.star.drawing.XDrawPage")
xPage = unoRuntime~queryInterface(xDrawPageName, xDrawPages~getByIndex(0))

xShapesName = .bsf4rexx~Class.class~forName("com.sun.star.drawing.XShapes")
xShapes = unoRuntime~queryInterface(xShapesName, xPage)

-- Set slide transition effect
fade = bsf("getStaticValue", "com.sun.star.presentation.FadeEffect", "FADE_FROM_RIGHT")
fast = bsf("getStaticValue", "com.sun.star.presentation.AnimationSpeed", "FAST")
call setSlideTransition xPage, fade, fast, 1, 0
	-- automatic object and slide transition

-- Create a rectangle that is placed on the top left of the page
point = .bsf~new("com.sun.star.awt.Point", 1000, 1000)
size = .bsf~new("com.sun.star.awt.Size", 5000, 5000)
xShapePropSet = createAndInsertShape(xDrawComponent, xShapes, point, size, "com.sun.star.drawing.RectangleShape")
line = bsf("getStaticValue", "com.sun.star.presentation.AnimationEffect", "WAVYLINE_FROM_BOTTOM")
xShapePropSet~setPropertyValue("Effect", line)

-- The following three properties provoke that the shape is dimmed to red 
-- after the animation has been finished
xShapePropSet~setPropertyValue("DimHide", .bsf~new("java.lang.Boolean", false))
xShapePropSet~setPropertyValue("DimPrevious", .bsf~new("java.lang.Boolean", true))
xShapePropSet~setPropertyValue("DimColor", .bsf~new("java.lang.Integer", 16711680))

-- Set the slide transition for the second page
xPage = unoRuntime~queryInterface(xDrawPageName, xDrawPages~getByIndex(1))
xShapes = unoRuntime~queryInterface(xShapesName, xPage)

slow = bsf("getStaticValue", "com.sun.star.presentation.AnimationSpeed", "SLOW")
call setSlideTransition xPage, fade, slow, 1, 0
	-- automatic object and slide transition

-- Create an ellipse that is placed on the bottom right of second page
point = .bsf~new("com.sun.star.awt.Point", 21000, 15000)
xShapePropSet = createAndInsertShape(xDrawComponent, xShapes, point, size, "com.sun.star.drawing.EllipseShape")
hide = bsf("getStaticValue", "com.sun.star.presentation.AnimationEffect", "HIDE")
xShapePropSet~setPropertyValue("Effect", hide)

-- Create two objects for the third page:
-- Clicking the first object lets the presentation jump
-- to page one by using ClickAction.FIRSTPAGE,
-- the second object lets the presentation jump to page two
-- by using a ClickAction.BOOKMARK.
xPage = unoRuntime~queryInterface(xDrawPageName, xDrawPages~getByIndex(2))
xShapes = unoRuntime~queryInterface(xShapesName, xPage)
roll = bsf("getStaticValue", "com.sun.star.presentation.FadeEffect", "ROLL_FROM_LEFT")
medium = bsf("getStaticValue", "com.sun.star.presentation.AnimationSpeed", "MEDIUM")
call setSlideTransition xPage, roll, medium, 2, 0
point = .bsf~new("com.sun.star.awt.Point", 1000, 8000)
xShape = createShape(xDrawComponent, point, size, "com.sun.star.drawing.EllipseShape")

xShapes~add(xShape)
call addPortion xShape, "click to go", 0
call addPortion xShape, "to first page", 1

xPropertySetName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
xShapePropSet = unoRuntime~queryInterface(xPropertySetName, xShape)
fadebottom = bsf("getStaticValue", "com.sun.star.presentation.AnimationEffect", "FADE_FROM_BOTTOM")
xShapePropSet~setPropertyValue("Effect", fadebottom)
firstpage = bsf("getStaticValue", "com.sun.star.presentation.ClickAction", "FIRSTPAGE")
xShapePropSet~setPropertyValue("OnClick", firstpage)
point = .bsf~new("com.sun.star.awt.Point", 22000, 8000)
xShape = createShape(xDrawComponent, point, size, "com.sun.star.drawing.RectangleShape")

xShapes~add(xShape)
call addPortion xShape, "click to go", 0
call addPortion xShape, "to the second page", 1
xShapePropSet = unoRuntime~queryInterface(xPropertySetName, xShape)
xShapePropSet~setPropertyValue("Effect", fadebottom)
bookmark = bsf("getStaticValue", "com.sun.star.presentation.ClickAction", "BOOKMARK")
xShapePropSet~setPropertyValue("OnClick", bookmark)

-- Set the name of page two, and use it with the bookmark action
xPage = unoRuntime~queryInterface(xDrawPageName, xDrawPages~getByIndex(1))
xNamedName = .bsf4rexx~Class.class~forName("com.sun.star.container.XNamed")
xPageName = unoRuntime~queryInterface(xNamedName, xPage)
xPageName~setName("page two")
xShapePropSet~bsf.invokeStrict("setPropertyValue", "ST", "Bookmark", "ST", xPageName~getName)

-- Start an endless presentation which is displayed in
-- full-screen mode and placed on top
xPresentationSupplierName = .bsf4rexx~Class.class~forName("com.sun.star.presentation.XPresentationSupplier")
xPresSupplier = unoRuntime~queryInterface(xPresentationSupplierName, xDrawComponent)
xPresentation = xPresSupplier~getPresentation
xPresPropSet = unoRuntime~queryInterface(xPropertySetName, xPresentation)
xPresPropSet~setPropertyValue("IsEndless", .bsf~new("java.lang.Boolean", true))
xPresPropSet~setPropertyValue("IsAlwaysOnTop", .bsf~new("java.lang.Boolean", true))
xPresPropSet~setPropertyValue("Pause", .bsf~new("java.lang.Integer", 0))
xPresentation~bsf.invoke("start")

EXIT

-- Auxiliary functions used in the example: ------------------------------

-- This simple method applies the slide transition to a page
setSlideTransition: PROCEDURE
use arg xPage, eEffect, eSpeed, nChange, nDuration
	unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")
	-- The following test is only sensible if you do not exactly know
	-- what type of page xPage is, for this purpose it can been tested
	-- if the com.sun.star.presentation.DrawPage service is supported
	xServiceInfoName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XServiceInfo")
	xInfo = unoRuntime~queryInterface(xServiceInfoName, xPage)

	if xInfo~supportsService("com.sun.star.presentation.DrawPage") then
	do
		xPropertySetName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
		xPropSet = unoRuntime~queryInterface(xPropertySetName, xPage)
		xPropSet~setPropertyValue("Effect", eEffect)
		xPropSet~setPropertyValue("Speed", eSpeed)
		xPropSet~setPropertyValue("Change", .bsf~new("java.lang.Integer", nChange))
		xPropSet~setPropertyValue("Duration", .bsf~new("java.lang.Integer", nDuration))
	end
	RETURN

createAndInsertShape: PROCEDURE
use arg xDrawDoc, xShapes, aPos, aSize, sShapeType
	unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")
	xShape = createShape(xDrawDoc, aPos, aSize, sShapeType)
	xShapes~add(xShape)
	xPropertySetName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
	xPropSet = unoRuntime~queryInterface(xPropertySetName, xShape)
	RETURN xPropSet
	
createShape: PROCEDURE
use arg xDrawDoc, aPos, aSize, sShapeType
	unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")
	xMultiServiceFactoryName = .bsf4rexx~Class.class~forName("com.sun.star.lang.XMultiServiceFactory")
	xFactory = unoRuntime~queryInterface(xMultiServiceFactoryName, xDrawDoc)
	xObj = xFactory~createInstance(sShapeType);
	xShapeName = .bsf4rexx~Class.class~forName("com.sun.star.drawing.XShape")
	xShape = unoRuntime~queryInterface(xShapeName, xObj)

	xShape~setPosition(aPos)
	xShape~setSize(aSize)

	RETURN xShape

addPortion: PROCEDURE
use arg xShape, sText, bNewParagraph
	unoRuntime = .bsf~new("com.sun.star.uno.UnoRuntime")
	xTextName = .bsf4rexx~Class.class~forName("com.sun.star.text.XText")
	xText = unoRuntime~queryInterface(xTextName, xShape)

	xTextCursor = xText~createTextCursor
	xTextCursor~gotoEnd(false)
	if bNewParagraph = 1 then
	do
		pbreak = bsf("getStaticValue", "com.sun.star.text.ControlCharacter", "PARAGRAPH_BREAK")
		xText~insertControlCharacter(xTextCursor, pbreak, false)
		xTextCursor~gotoEnd(false)
	end
	
	xTextRangeName = .bsf4rexx~Class.class~forName("com.sun.star.text.XTextRange")
	xTextRange = unoRuntime~queryInterface(xTextRangeName, xTextCursor)
	xTextRange~setString(sText)
	xTextCursor~gotoEnd(true)
	xPropertySetName = .bsf4rexx~Class.class~forName("com.sun.star.beans.XPropertySet")
	xPropSet = unoRuntime~queryInterface(xPropertySetName, xTextRange)

	RETURN xPropSet


::requires "BSF.cls"