-- [30][OLE][Rexx]
-- The service manager is always the starting point
-- If there is no office running then an office is started up
objServiceManager = .OLEObject~new("com.sun.star.ServiceManager")

-- Create the Desktop
objDesktop= objServiceManager~createInstance("com.sun.star.frame.Desktop")

-- Open a new empty writer document
args = .array~new(0)
objDocument= objDesktop~loadComponentFromURL("private:factory/swriter", "_blank", 0, args)

-- Create a text object
objText= objDocument~getText()

-- Create a cursor object
objCursor= objText~createTextCursor()

-- Inserting some Text
objText~insertString(objCursor, "The first line in the newly created text document."||"0A"X, .false)
  
-- Inserting a second line
objText~insertString(objCursor, "Now we're in the second line", .false)

-- Create instance of a text table with 4 columns and 4 rows
objTable= objDocument~createInstance("com.sun.star.text.TextTable")
objTable~initialize(4, 4)

-- Insert the table
objText~insertTextContent(objCursor, objTable, .false)

-- Get first row
objRows = objTable~getRows()
objRow = objRows~getByIndex(0)

-- Set the table background color
objTable~setPropertyValue("BackTransparent", false)
objTable~setPropertyValue("BackColor", 13421823)

-- Set a different background color for the first row
objRow~setPropertyValue("BackTransparent", .false)
objRow~setPropertyValue("BackColor", 6710932)

-- Fill the first table row
call insertIntoCell "A1", "FirstColumn", objTable
call insertIntoCell "B1","SecondColumn", objTable
call insertIntoCell "C1","ThirdColumn", objTable
call insertIntoCell "D1", "SUM", objTable

objTable~getCellByName("A2")~setValue(22.5)
objTable~getCellByName("B2")~setValue(5615.3)
objTable~getCellByName("C2")~setValue(-2315.7)
objTable~getCellByName("D2")~setFormula("sum <A2:C2>")
    
objTable~getCellByName("A3")~setValue(21.5)
objTable~getCellByName("B3")~setValue(615.3)
objTable~getCellByName("C3")~setValue(-315.7)
objTable~getCellByName("D3")~setFormula("sum <A3:C3>")
           
objTable~getCellByName("A4")~setValue(121.5)
objTable~getCellByName("B4")~setValue(-615.3)
objTable~getCellByName("C4")~setValue(415.7)
objTable~getCellByName("D4")~setFormula("sum <A4:C4>")
    
-- Change the CharColor and add a Shadow
objCursor~setPropertyValue("CharColor", 255)
--objCursor~setPropertyValue("CharShadowed", true)

-- Create a paragraph break
PARAGRAPH_BREAK = 0
objText~insertControlCharacter(objCursor, PARAGRAPH_BREAK, .false)

-- Inserting colored Text.
objText~insertString(objCursor, "This is a colored Text - blue with shadow" ||"0A"X, .false)

-- Create a paragraph break (ControlCharacter::PARAGRAPH_BREAK).
objText~insertControlCharacter(objCursor, PARAGRAPH_BREAK, .false)
      
-- Create a TextFrame.
objTextFrame = objDocument~createInstance("com.sun.star.text.TextFrame")

-- Create a Size struct.
objTextFrame~FrameHeightAbsolute = 400
objTextFrame~FrameWidthAbsolute = 15000

-- TextContentAnchorType.AS_CHARACTER = 1
AS_CHARACTER = 1
objTextFrame~setPropertyValue("AnchorType", AS_CHARACTER)

-- insert the frame
objText~insertTextContent(objCursor, objTextFrame, .false)

-- Get the text object of the frame
objFrameText = objTextFrame~getText

-- Create a cursor object
objFrameTextCursor = objFrameText~createTextCursor
    
-- Inserting some Text
objFrameText~insertString(objFrameTextCursor, "The first line in the newly created text frame.", .false)
objFrameText~insertString(objFrameTextCursor, "0A"X || "With this second line the height of the frame raises.", .false)

-- Create a paragraph break
objFrameText~insertControlCharacter(objCursor, PARAGRAPH_BREAK , .false)

-- Change the CharColor and add a Shadow
objCursor~setPropertyValue("CharColor", 65536)
objCursor~setPropertyValue("CharShadowed", .false)


-- Insert another string
objText~insertString(objCursor, " That' s all for now !!", .false)

EXIT

insertIntoCell: PROCEDURE
	use arg strCellName, strText, objTable
	objCellText = objTable~getCellByName(strCellName)
	objCellCursor = objCellText~createTextCursor()
	objCellCursor~setPropertyValue("CharColor", 16777215)
	objCellText~insertString(objCellCursor, strText, .false)
	RETURN


:: requires "OREXXOLE.CLS"
