<?

// [31][OLE][PHP]
// Testing COM/OLE

// Adapted from the Open Office SDK writerdemo.vbs example

echo "<h1>Testing COM/OLE</h1>\n";

// The service manager is always the starting point
// If there is no office running then an office is started up
$objServiceManager = new COM("com.sun.star.ServiceManager");

// Create the CoreReflection service that is later used to create structs
$objCoreReflection = $objServiceManager->createInstance("com.sun.star.reflection.CoreReflection");

// Create the Desktop
$objDesktop= $objServiceManager->createInstance("com.sun.star.frame.Desktop");

// Open a new empty writer document
$args = array();
$objDocument= $objDesktop->loadComponentFromURL("private:factory/swriter", "_blank", 0, $args);

// Create a text object
$objText= $objDocument->getText();

// Create a cursor object
$objCursor= $objText->createTextCursor();

// Inserting some Text
$objText->insertString($objCursor, "The first line in the newly created text document.\n", false);
  
// Inserting a second line
$objText->insertString($objCursor, "Now we're in the second line", false);

// Create instance of a text table with 4 columns and 4 rows
$objTable= $objDocument->createInstance("com.sun.star.text.TextTable");
$objTable->initialize(4, 4);

// Insert the table
$objText->insertTextContent($objCursor, $objTable, false);

// Get first row
$objRows= $objTable->getRows();
$objRow= $objRows->getByIndex(0);

// Set the table background color
$objTable->setPropertyValue("BackTransparent", false);
$objTable->setPropertyValue("BackColor", 13421823);

// Set a different background color for the first row
$objRow->setPropertyValue("BackTransparent", false);
$objRow->setPropertyValue("BackColor", 6710932);

// Fill the first table row
insertIntoCell("A1", "FirstColumn", $objTable);
insertIntoCell("B1", "SecondColumn", $objTable);
insertIntoCell("C1", "ThirdColumn", $objTable);
insertIntoCell("D1", "SUM", $objTable);

$objCell = $objTable->getCellByName("A2");
$objCell->setValue(22.5);
$objCell = $objTable->getCellByName("B2");
$objCell->setValue(5615.3);
$objCell = $objTable->getCellByName("C2");
$objCell->setValue(-2315.7);
$objCell = $objTable->getCellByName("D2");
$objCell->setFormula("sum <A2:C2>");
    
$objCell = $objTable->getCellByName("A3");
$objCell->setValue(21.5);
$objCell = $objTable->getCellByName("B3");
$objCell->setValue(615.3);
$objCell = $objTable->getCellByName("C3");
$objCell->setValue(-315.7);
$objCell = $objTable->getCellByName("D3");
$objCell->setFormula("sum <A3:C3>");
           
$objCell = $objTable->getCellByName("A4");
$objCell->setValue(121.5);
$objCell = $objTable->getCellByName("B4");
$objCell->setValue(-615.3);
$objCell = $objTable->getCellByName("C4");
$objCell->setValue(415.7);
$objCell = $objTable->getCellByName("D4");
$objCell->setFormula("sum <A4:C4>");

// Create a paragraph break
// The second argument is a com::sun::star::text::ControlCharacter::PARAGRAPH_BREAK constant
$objText->insertControlCharacter($objCursor, 0 , false);

// Inserting colored Text.
$objText->insertString($objCursor, " This is a colored Text - blue with shadow\n", false);

// Create a paragraph break ( ControlCharacter::PARAGRAPH_BREAK).
$objText->insertControlCharacter($objCursor, 0, false);
      
// Create a TextFrame.
$objTextFrame= $objDocument->createInstance("com.sun.star.text.TextFrame");

// Set size
$objTextFrame->FrameHeightAbsolute = 400;
$objTextFrame->FrameWidthAbsolute = 15000;

// TextContentAnchorType.AS_CHARACTER = 1
$objTextFrame->setPropertyValue("AnchorType", 1);

// insert the frame
$objText->insertTextContent($objCursor, $objTextFrame, false);

// Get the text object of the frame
$objFrameText= $objTextFrame->getText();

// Create a cursor object
$objFrameTextCursor= $objFrameText->createTextCursor();
    
// Inserting some Text
$objFrameText->insertString($objFrameTextCursor, "The first line in the newly created text frame.", false);
$objFrameText->insertString($objFrameTextCursor, "\nWith this second line the height of the frame raises.", false);

// Create a paragraph break
// The second argument is a com::sun::star::text::ControlCharacter::PARAGRAPH_BREAK constant
$objFrameText->insertControlCharacter($objCursor, 0 , false);

// Change the CharColor and add a Shadow
$objCursor->setPropertyValue("CharColor", 65536);
$objCursor->setPropertyValue("CharShadowed", false);

// Insert another string
$objText->insertString($objCursor, " That' s all for now !!", false);

function insertIntoCell($strCellName, $strText, $objTable) 
{
    $objCellText= $objTable->getCellByName($strCellName);
    $objCellCursor= $objCellText->createTextCursor();
    $objCellCursor->setPropertyValue("CharColor", 16777215);
    $objCellText->insertString($objCellCursor, $strText, false);
}

?>