-- [33][BSF][Rexx]
-- Using the Java LiveDoc from Rexx

-- Requires
--	(1) Rainer Hahnekamp's ljd.jar (see [Hahnek05])
-- 	(2) The Saxon XML processing tools: saxon.jar, from http://saxon.sourceforge.net
-- to be available for BSF
-- For details, see [Hahnek05] (Rainer Hahnekamp's course paper)
-- (This example does not require further components of OOBabylon.)

-- IMPORTANT: Some configuration is required: =================

-- The class to analyze
className = "java.lang.Math"
-- How to call your browser
browserPath = "C:\Programme\Mozilla Firefox\firefox.exe"
-- Where to put generated files
outputDir = "C:\"

-- End of configuration =======================================

-- Instantiate Java LiveDoc object
ljd = .bsf~new("org.ljd.LJD", className)
-- Create XML output file (contains the class description)
fWriter = .bsf~new("java.io.FileWriter", outputDir || className || ".xml")
-- Write XML output
outputter = ljd~bsf.getFieldValue("outputter")
output = outputter~getOutput
fWriter~bsf.invokeStrict("write", "ST", output)
--fWriter~write(output)
fWriter~flush()
fWriter~close()

-- Instantiate an XML transformer factory
factory = .bsf~new("com.icl.saxon.TransformerFactoryImpl")

-- Read in the XML file containing the class description from above
sourceFile = .bsf~new("java.io.File", outputDir || className || ".xml")
eis = .bsf~new("com.icl.saxon.ExtendedInputSource", sourceFile)
sourceInput = .bsf~new("javax.xml.transform.sax.SAXSource", factory~getSourceParser, eis)

-- Read in the XSL stylesheet
sheetFile = .bsf~new("java.io.File", "transform.xsl")
eis = .bsf~new("com.icl.saxon.ExtendedInputSource", sheetFile)
styleSource = .bsf~new("javax.xml.transform.sax.SAXSource", factory~getSourceParser, eis)
sheet = factory~newTemplates(styleSource)

-- Apply stylesheet and write output to HTML file
outputFile = .bsf~new("java.io.File", outputDir || className || ".html")
params = .bsf~new("com.icl.saxon.ParameterSet")
styleSheet = .bsf~new("com.icl.saxon.StyleSheet")
styleSheet~processFile(sourceInput, sheet, outputFile, params)

-- Finally, open up a browser window and display the HTML file	
runtimeName = .bsf4rexx~Class.class~forName("java.lang.Runtime")
runtime = bsf("invoke", runtimeName, getRuntime)
abspath = outputFile~getAbsolutePath
bsf("invokeStrict", runtime, "exec", "ST", browserPath || " " || abspath)


::requires "BSF.cls"