/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.lang.reflect.Method;
import org.jdom.output.EscapeStrategy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Format
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: Format.java,v $ $Revision: 1.5 $ $Date: 2004/02/06 09:28:32 $ $Name: jdom_1_0_b10_rc1 $";
    private static final String STANDARD_INDENT = "  ";
    private static final String STANDARD_LINE_SEPARATOR = "\r\n";
    private static final String STANDARD_ENCODING = "UTF-8";
    String indent;
    String lineSeparator;
    String encoding;
    boolean omitDeclaration;
    boolean omitEncoding;
    boolean expandEmptyElements;
    TextMode mode;
    EscapeStrategy escapeStrategy;
    static /* synthetic */ Class class$java$lang$String;

    public static Format getRawFormat() {
        return new Format();
    }

    public static Format getPrettyFormat() {
        Format f = new Format();
        f.setIndent(STANDARD_INDENT);
        f.setTextMode(TextMode.TRIM);
        return f;
    }

    public static Format getCompactFormat() {
        Format f = new Format();
        f.setTextMode(TextMode.NORMALIZE);
        return f;
    }

    public Format setEscapeStrategy(EscapeStrategy strategy) {
        this.escapeStrategy = strategy;
        return this;
    }

    public EscapeStrategy getEscapeStrategy() {
        return this.escapeStrategy;
    }

    public Format setLineSeparator(String separator) {
        this.lineSeparator = separator;
        return this;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public Format setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
        return this;
    }

    public boolean getOmitEncoding() {
        return this.omitEncoding;
    }

    public Format setOmitDeclaration(boolean omitDeclaration) {
        this.omitDeclaration = omitDeclaration;
        return this;
    }

    public boolean getOmitDeclaration() {
        return this.omitDeclaration;
    }

    public Format setExpandEmptyElements(boolean expandEmptyElements) {
        this.expandEmptyElements = expandEmptyElements;
        return this;
    }

    public boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public Format setTextMode(TextMode mode) {
        this.mode = mode;
        return this;
    }

    public TextMode getTextMode() {
        return this.mode;
    }

    public Format setIndent(String indent) {
        if ("".equals(indent)) {
            indent = null;
        }
        this.indent = indent;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public Format setEncoding(String encoding) {
        this.encoding = encoding;
        this.escapeStrategy = new DefaultEscapeStrategy(encoding);
        return this;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected Object clone() {
        Format format = null;
        try {
            format = (Format)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return format;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.indent = null;
        this.lineSeparator = STANDARD_LINE_SEPARATOR;
        this.encoding = STANDARD_ENCODING;
        this.omitDeclaration = false;
        this.omitEncoding = false;
        this.expandEmptyElements = false;
        this.mode = TextMode.PRESERVE;
        this.escapeStrategy = new DefaultEscapeStrategy(this.encoding);
    }

    Format() {
        this.this();
    }

    class DefaultEscapeStrategy
    implements EscapeStrategy {
        private int bits;
        Object encoder;
        Method canEncode;

        public boolean shouldEscape(char ch) {
            if (this.bits == 16) {
                return false;
            }
            if (this.bits == 8) {
                return ch > '\u00ff';
            }
            if (this.bits == 7) {
                return ch > '\u007f';
            }
            if (this.canEncode != null && this.encoder != null) {
                try {
                    Boolean val = (Boolean)this.canEncode.invoke(this.encoder, new Character(ch));
                    return val ^ true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }

        public DefaultEscapeStrategy(String encoding) {
            if (Format.STANDARD_ENCODING.equalsIgnoreCase(encoding) || "UTF-16".equalsIgnoreCase(encoding)) {
                this.bits = 16;
            } else if ("ISO-8859-1".equalsIgnoreCase(encoding) || "Latin1".equalsIgnoreCase(encoding)) {
                this.bits = 8;
            } else if ("US-ASCII".equalsIgnoreCase(encoding) || "ASCII".equalsIgnoreCase(encoding)) {
                this.bits = 7;
            } else {
                this.bits = 0;
                try {
                    Class<?> charsetClass = Class.forName("java.nio.charset.Charset");
                    Class<?> encoderClass = Class.forName("java.nio.charset.CharsetEncoder");
                    Class[] classArray = new Class[1];
                    Class clazz = class$java$lang$String;
                    if (clazz == null) {
                        clazz = class$java$lang$String = Format.class$("[Ljava.lang.String;", false);
                    }
                    classArray[0] = clazz;
                    Method forName = charsetClass.getMethod("forName", classArray);
                    Object charsetObj = forName.invoke(null, encoding);
                    Method newEncoder = charsetClass.getMethod("newEncoder", null);
                    this.encoder = newEncoder.invoke(charsetObj, null);
                    this.canEncode = encoderClass.getMethod("canEncode", Character.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static class TextMode {
        public static final TextMode PRESERVE = new TextMode("PRESERVE");
        public static final TextMode TRIM = new TextMode("TRIM");
        public static final TextMode NORMALIZE = new TextMode("NORMALIZE");
        public static final TextMode TRIM_FULL_WHITE = new TextMode("TRIM_FULL_WHITE");
        private final String name;

        public String toString() {
            return this.name;
        }

        private TextMode(String name) {
            this.name = name;
        }
    }
}

