/*
 * author: Rainer Hahnekamp
 * 
 * The Analyzer class does - as the name already says - the main part of the analyzing process. It
 * makes intensly use of the reflection methods and writes the fields, constructors, methods, interfaces
 * and superclasses into HashMap objects. These objects are later used for the Outputter class to
 * bringt them all together and write their data into the final XML string.
 */

package org.ljd;

import java.lang.reflect.*;
import java.util.ArrayList;
import java.util.HashMap;

class Analyzer {
	private HashMap fields = new HashMap();

	private HashMap constructors = new HashMap();

	private HashMap methods = new HashMap();

	private HashMap interfaces = new HashMap();

	private ArrayList superClasses = new ArrayList();

	private HashMap modifiers = new HashMap();

	private Class myClass;

	Analyzer(Class myClass) throws ClassNotFoundException {
		this.myClass = myClass;
	}
	
	//this method starts the main process of the analyzation
	protected Outputter analyze() {
		//each of the following methods examines the class and fills the appropriate HashMap object
		getConstructors(myClass.getConstructors());
		getMethods(myClass.getMethods());
		getFields(myClass.getFields());
		getInterfaces(myClass.getInterfaces());
		if(!myClass.isInterface()) getSuperClasses(myClass);

		//finally an Outputter object is created and filled with data. This object will be returned to the LJD class
		Outputter outputter = new Outputter(myClass.getName());
		outputter.setConstructors(constructors);
		outputter.setFields(fields);
		outputter.setInterfaces(interfaces);
		outputter.setMethods(methods);
		outputter.setModifiers(modifiers);
		outputter.setSuperClasses(superClasses);
		return outputter;
	}

	protected ArrayList getModifiers(int m) {
		ArrayList list = new ArrayList();
		if (Modifier.isAbstract(m))
			list.add("abstract");
		if (Modifier.isFinal(m))
			list.add("final");
		if (Modifier.isInterface(m))
			list.add("interactive");
		if (Modifier.isNative(m))
			list.add("native");
		if (Modifier.isPrivate(m))
			list.add("private");
		if (Modifier.isProtected(m))
			list.add("protected");
		if (Modifier.isPublic(m))
			list.add("public");
		if (Modifier.isStatic(m))
			list.add("static");
		if (Modifier.isStrict(m))
			list.add("strict");
		if (Modifier.isSynchronized(m))
			list.add("synchronized");
		if (Modifier.isTransient(m))
			list.add("transient");
		if (Modifier.isVolatile(m))
			list.add("volatile");

		return list;
	}

	private void getSuperClasses(Class c) {
		while (!c.getName().equals("java.lang.Object")) {
			c = c.getSuperclass();
			this.superClasses.add(c);
			/* the call of the following method must be done because a class has also the methods, fields and
			 * interfaces of its superclass
			 */
			getInterfaces(c.getInterfaces());
			getFields(c.getFields());
			getMethods(c.getMethods());
		}
	}

	private void getInterfaces(Class[] interfaces) {
		for (int i = 0; i < interfaces.length; i++) {
			Class myInterface = (Class) interfaces[i];
			this.interfaces.put(myInterface.getName(), myInterface);
			/* the call of the following methods has the effect that also the field, interfaces and methods are
			 * finally documented since according to the rule of implementation an interface they must be also
			 * be available.
			 */
			getInterfaces(myInterface.getInterfaces());
			getFields(myInterface.getFields());
			getMethods(myInterface.getMethods());
		}
	}

	private void getFields(Field[] fields) {
		for (int i = 0; i < fields.length; i++) {
			this.fields.put(fields[i].getName(), fields[i]);
		}
	}

	private void getConstructors(Constructor[] constructors) {
		for (int i = 0; i < constructors.length; i++) {
			this.constructors.put(constructors[i].getName(), constructors[i]);
		}
	}

	private void getMethods(Method[] methods) {
		for (int i = 0; i < methods.length; i++) {
			this.methods.put(methods[i].getName(), methods[i]);
		}
	}
}