package org.ljd;

/*
 * author: Rainer Hahnekamp
 * 
 * This is the main class of Live JavaDoc and expects as parameter the class which has to be analyzed.
 * It passes the name of the class on to the Analyzer object which does the analyzation and returns an
 * outputter object which is made public in this class. The outputter delivers an XML string containing
 * all the analyzed data of the class.
 */
public class LJD {
	private Analyzer analyzer;
	public Outputter outputter;
	
	public static void main(String args[]) {
		LJD ljd = new LJD(args[0]);
		System.out.println(ljd.outputter.getOutput());
	}
	
	public LJD (String className) {
		try {
			start(Class.forName(className));	
		}
		catch (ClassNotFoundException cnfe) {
			System.err.println("Could not find class");
			System.err.println("Error: " + cnfe);
		}
	}
	public LJD (Class myClass) {
		start(myClass);
	}
	
	private void start(Class myClass) {
		try {
			analyzer = new Analyzer(myClass);
			outputter = analyzer.analyze();
		}
		catch (Exception e) {
			System.err.println("class object could not be retrieved");
			e.printStackTrace();
		}
	}
}