package org.ljd;

import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import java.lang.reflect.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * author: Rainer Hahnekamp
 * 
 * This class is responsible for creating an XML string. It gets its data from
 * the Analyzer class which also iniates an Outputter object. For building the
 * XML the jdom library is used.
 */

public class Outputter {
	private Element root = new Element("class");

	private XMLOutputter output = new XMLOutputter();

	private String className;

	public final String CLASS = "class";

	public final String INTERFACE = "interface";

	//these are the objects which come from the Analyzer class
	private HashMap constructors, fields, interfaces, methods, modifiers;

	private ArrayList path;

	Outputter(String className) {
		this.className = className;
	}

	private void output() {
		root.setAttribute("name", className);
		root.addContent(getModifiers());
		root.addContent(getSuperClasses());
		root.addContent(getInterfaces());
		root.addContent(getConstructors());
		root.addContent(getMethods());
		root.addContent(getFields());
		//output.setNewlines(true);
		//output.setIndent("\t");
	}

	public String getOutput() {
		output();
		return output.outputString(root);
	}

	protected Outputter getMe() {
		return this;
	}

	protected void setConstructors(HashMap constructors) {
		this.constructors = constructors;
	}

	protected void setFields(HashMap fields) {
		this.fields = fields;
	}

	protected void setMethods(HashMap methods) {
		this.methods = methods;
	}

	protected void setInterfaces(HashMap interfaces) {
		this.interfaces = interfaces;
	}

	protected void setSuperClasses(ArrayList path) {
		this.path = path;
	}

	protected void setModifiers(HashMap modifiers) {
		this.modifiers = modifiers;
	}

	private Element getConstructors() {

		ArrayList constructors = sort(this.constructors);
		Element main = new Element("constructors");
		for (int i = 0; i < constructors.size(); i++) {
			Constructor constructor = (Constructor) constructors.get(i);
			Element constructorE = new Element("constructor");
			Element exceptionE = getExceptionNode(constructor.getExceptionTypes());
			if (exceptionE != null) {
				constructorE.addContent(exceptionE);
			}
			Element parameterE = getParameterNode(constructor.getParameterTypes());
			if (parameterE != null) {
				constructorE.addContent(parameterE);
			}
			main.addContent(constructorE);
		}
		return main;
	}

	private Element getFields() {
		Element main = new Element("fields");
		ArrayList fields = sort(this.fields);
		for (int i = 0; i < fields.size(); i++) {
			Field field = (Field) fields.get(i);
			Element fieldE = new Element("field");
			Element nameE = new Element("name");
			nameE.setText(field.getName());
			Element nameT = new Element("type");
			nameT.setText(field.getType().getName());
			fieldE.addContent(nameE);
			fieldE.addContent(nameT);
			main.addContent(fieldE);
		}
		return main;
	}

	private Element getInterfaces() {
		Element main = new Element("interfaces");
		ArrayList interfaces = sort(this.interfaces);
		for (int i = 0; i < interfaces.size(); i++) {
			Class myInterface = (Class) interfaces.get(i);
			Element interfaceE = new Element("interface");
			interfaceE.setText(myInterface.getName());
			main.addContent(interfaceE);
		}

		return main;
	}

	private Element getMethods() {
		Element main = new Element("methods");
		ArrayList methods = sort(this.methods);
		String returnType;
		for (int i = 0; i < methods.size(); i++) {
			Method myMethod = (Method) methods.get(i);
			Element method = new Element("method");
			Element methodN = new Element("name");
			methodN.setText(myMethod.getName());
			Element methodR = new Element("return");
			methodR.setText(formatObject(myMethod.getReturnType().getName()));
			method.addContent(methodN);
			method.addContent(methodR);
			Element elementE = getExceptionNode(myMethod.getExceptionTypes());
			if (elementE != null)
				method.addContent(elementE);
			Element elementP = getParameterNode(myMethod.getParameterTypes());
			if (elementP != null)
				method.addContent(elementP);
			main.addContent(method);
		}

		return main;
	}

	private Element getModifiers() {
		Element main = new Element("modifiers");
		ArrayList modifiers = sort(this.modifiers);
		for (int i = 0; i < modifiers.size(); i++) {
			main.addContent(new Element(modifiers.get(i).toString()));
		}

		return main;
	}

	private Element getSuperClasses() {
		Element main = new Element("superclasses");
		for (int i = 0; i < path.size(); i++) {
			Element classElement = new Element("superclass");
			classElement.setText(path.get(i).toString());
			main.addContent(classElement);
		}
		return main;
	}

	//this class returns a node containing all possible exceptions that can occur
	private Element getExceptionNode(Class[] exceptions) {
		if (exceptions.length == 0)
			return null;

		Element main = new Element("exceptions");
		for (int i = 0; i < exceptions.length; i++) {
			Class exception = (Class) exceptions[i];
			Element exceptionE = new Element("exception");
			exceptionE.setText(exception.getName());
			main.addContent(exceptionE);
		}

		return main;
	}

	//this method returns a node containing all parameters for a method or
	// constructor
	private Element getParameterNode(Class[] parameters) {
		if (parameters.length == 0)
			return null;

		Element main = new Element("parameters");
		for (int i = 0; i < parameters.length; i++) {
			Element constructorParam = new Element("parameter");
			Class myParam = (Class) parameters[i];
			constructorParam.addContent(myParam.getName());
			main.addContent(constructorParam);
		}
		return main;
	}

	private String formatObject(String objectName) {
		if (objectName.startsWith("[L")) {
			return objectName.substring(2, objectName.length() - 1) + "[]";
		}
		return objectName;
	}

	//this methods finally sorts the HashMap objects alphabetically
	private ArrayList sort(HashMap hash) {
		ArrayList list = new ArrayList();

		Set set = hash.keySet();
		Iterator iter = set.iterator();
		while (iter.hasNext()) {
			list.add(iter.next());
		}

		Collections.sort(list);

		for (int i = 0; i < list.size(); i++) {
			list.set(i, hash.get(list.get(i)));
		}

		return list;
	}
}