/* get the service manager */
xContext = UNO.connect()
XMcf = xContext~getServiceManager

/* retrieve the DatabaseContext and get its XSingleServiceFactory interface */
xSingleServiceFactory = xMcf~createInstanceWithContext(-
	"com.sun.star.sdb.DatabaseContext", xContext)~XSingleServiceFactory

/* create a new generic data source */
dataSource = xSingleServiceFactory~createInstance

/* setting the necessary data source properties */
xPropertySet = dataSource~XPropertySet
/* MySQL URL */
xPropertySet~setPropertyValue("URL", "sdbc:mysql:jdbc:localhost:3306/test")
/* force password dialog */
xPropertySet~setPropertyValue(-
	"IsPasswordRequired",.bsf~new("java.lang.Boolean","true"))
/* suggest 'stefan' as user name */
xPropertySet~setPropertyValue("User", "stefan")

/* determine the JDBC driver */
props = bsf.createArray(.UNO~propertyValue,1)
props[1] = .UNO~PropertyValue~new
props[1]~Name = "JavaDriverClass"
props[1]~Value = "com.mysql.jdbc.Driver"
xPropertySet~setPropertyValue("Info", props)

/* get the XDocumentDataSource interface of the data source */
xDocumentDataSource = dataSource~XDocumentDataSource

/* get the OfficeDatabaseDocument service via the 'DatabaseDocument' attribute*/
xOfficeDatabaseDocument = xDocumentDataSource~getDatabaseDocument

/* retrieve the XStorable, xClosable, and XModel interface */
xStorable = xOfficeDatabaseDocument~XStorable
xCloseable = xOfficeDatabaseDocument~XCloseable
xModel = xOfficeDatabaseDocument~XModel

/* register it with the database context */
xNamingService = xSingleServiceFactory~XNamingService
url = uno.ConvertToURL("c:/odbfiles/mysql1.odb")
xStorable~storeAsURL(url,xModel~getArgs)
xNamingService~registerObject("mysql-test", dataSource)
say "database document has been stored to '"url"' !"

/* close database */
xCloseable~close(.true)
		
::requires UNO.cls -- get UNO support