/* get the service manager */
xContext = UNO.connect()
xMcf = xContext~getServiceManager

/* create RowSet object */
xRowSet = xMcf~createInstanceWithContext(-
	"com.sun.star.sdb.RowSet",xContext)~XRowSet
say "RowSet created!"

/* set the properties which are needed to connect to a database */
xPropertySet = xRowSet~XPropertySet
xPropertySet~setPropertyValue("DataSourceName", "mysql-test")
xPropertySet~setPropertyValue("User", "stefan")
xPropertySet~setPropertyValue("Password", "apple")

/* choose the CommandType TABLE and set the command */
xPropertySet~setPropertyValue("Command", "test.sales")
xPropertySet~setPropertyValue("CommandType", box(-
	"int",bsf.getStaticValue("com.sun.star.sdb.CommandType", "TABLE")))

/* now execute the previous specified command */
xRowSet~execute
say "RowSet executed!"

/* process the ResultSet */
say "Results:"
xRow = xRowSet~XRow
DO WHILE xRowSet~next <> .false
	name = xRow~getString(1)
	price = xRow~getString(2)
	price2 = xRow~getString(3)
	say name"-"price"-"price2
END

say
say "---Infos---"
/* show amount of returned rows*/
say "There are:" xPropertySet~getPropertyValue("RowCount") "rows"
/* show the currently used command */
say "Used Command:" xPropertySet~getPropertyValue("ActiveCommand")
say "-----------"
say

/* destroy the created RowSet */
xComp = xRowSet~XComponent~dispose
say "RowSet destroyed!" 

::requires UNO.cls -- get UNO support