/* get the service manager */
xContext = UNO.connect()
XMcf = xContext~getServiceManager

/* retrieve the DatabaseContext and get its XNameAccess interface */
xNameAccess = xMcf~createInstanceWithContext(-
	"com.sun.star.sdb.DatabaseContext", xContext)~XNameAccess

/* let's use the datasource mysql-test */
dataSource = xNameAccess~getByName("mysql-test")

/*create an empty QueryDefinition and request it's XPropertySet interface*/
xQueryDefinitionsSupplier = dataSource~XQueryDefinitionsSupplier
xQDefs = xQueryDefinitionsSupplier~getQueryDefinitions
xSingleServiceFactory = xQDefs~XSingleServiceFactory
xPropertySet = xSingleServiceFactory~createInstance~XPropertySet 

/* define the query */
xPropertySet~setPropertyValue("Command",-
	"SELECT firstname, lastname, product.name "-
	"FROM customer, sales, product "-
	"WHERE customer.cid = sales.cid AND sales.name = product.name")
	
xPropertySet~setPropertyValue(-
	"EscapeProcessing",box("BOOL",.true))

/* insert it into the query definition container */
xNameContainer = xQDefs~XNameContainer
queryName = "Query_names+products"
IF xNameContainer~hasByName(queryName) THEN 
DO 
	say "removing existing query definition...."
	xNameContainer~removeByName(queryName)
END


say "insert Query to the container...."
xNameContainer~insertByName(queryName,xPropertySet)


/* store the database document */

/* retrieve the XDocumentDataSource interface of the data source */
xDocumentDataSource = dataSource~XDocumentDataSource

/* get the attribute 'DatabaseDocument' */
xOfficeDatabaseDocument = xDocumentDataSource~getDatabaseDocument

/* store the database document and with it the query definition */
xStorable = xOfficeDatabaseDocument~XStorable~store
say "storing database document...."

::requires UNO.cls -- get UNO support
