-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first get the currently selected sheet
x_Model = x_Document~XModel
s_CurrentController = x_Model~getCurrentController()
x_View = s_CurrentController~XSpreadsheetView
x_Spreadsheet = x_View~getActiveSheet()

-- now create a virtual cursor on this sheet
-- with UsedAreaCursor Interface we just select the region with filled cells
x_SheetCellCursor = x_Spreadsheet~createCursor()
x_UsedAreaCursor = x_SheetCellCursor~XUsedAreaCursor
x_UsedAreaCursor~gotoStartOfUsedArea(.false)
x_UsedAreaCursor~gotoEndOfUsedArea(.true)

-- finally delete all cells and their properties in region
x_SheetOp = x_SheetCellCursor~XSheetOperation
x_SheetOp~clearContents(1+2+4+8+16+32+64+128+256+512)

::requires UNO.CLS