-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first get currently selected sheet
x_Model = x_Document~XModel
s_CurrentController = x_Model~getCurrentController()
x_View = s_CurrentController~XSpreadsheetView
x_Spreadsheet = x_View~getActiveSheet()

-- then get the drawpage (used for paintings) of the sheet
x_DrawPageSupplier = x_Spreadsheet~XDrawPageSupplier
x_DrawPage = x_DrawPageSupplier~getDrawPage()

-- create a new Shape and configure it
x_MultiServiceFactory = x_Document~XMultiServiceFactory
s_Shape = x_MultiServiceFactory~createInstance("com.sun.star.drawing.LineShape")

shapecolor = .bsf~new("java.lang.Integer", X2D("FF0000"))
shapeProperties = s_Shape~XPropertySet
shapeProperties~setPropertyValue("LineColor", shapecolor)
linelength = .bsf~new("java.lang.Integer", 500)
shapeProperties~setPropertyValue("LineWidth", linelength)

size = .bsf~new("com.sun.star.awt.Size")
size~bsf.setFieldValue("width", 25000)
size~bsf.setFieldValue("height", 14000)

pos = .bsf~new("com.sun.star.awt.Point")
pos~bsf.setFieldValue("X", 400)
pos~bsf.setFieldValue("Y", 400)

x_Shape = s_Shape~XShape
x_Shape~setSize(size)
x_Shape~setPosition(pos)

-- finally add the shape to the sheet
x_DrawPage~add(x_Shape)

::requires UNO.CLS