-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- create the pathservice
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
s_path = x_MultiServiceFactory~createInstance("com.sun.star.util.PathSettings")

-- access it by propertysets
pathproperties = s_path~XPropertySet

-- read the work entry
workdir = pathproperties~getPropertyValue("Work")

-- create a Folder Picker dialog
folderpicker = "com.sun.star.ui.dialogs.OfficeFolderPicker"
s_FolderDialog = x_MultiServiceFactory~createInstance(folderpicker)
x_FolderDialog = s_FolderDialog~XFolderPicker

-- Better name for our dialog:
x_FolderDialog~setDescription("Current Workdir: " || workdir)
x_FolderDialog~setDisplayDirectory(workdir)

pathchoosen = x_FolderDialog~execute()

-- if a path has been choosen write the new path into the
-- pathsettings service of Open Office
if ( pathchoosen ) then
do
   librarypath = x_FolderDialog~getDirectory()
   pathproperties~setPropertyValue("Work", librarypath)
end

::requires UNO.CLS