-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- this is the text we want to write
cliptext = ""

-- create the clipboard service controlling the clipboard of
-- the operating system
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
clipboard = "com.sun.star.datatransfer.clipboard.SystemClipboard"
s_Clipboard = x_MultiServiceFactory~createInstance(clipboard)
x_Clipboard = s_Clipboard~XClipboard

-- get the clipboard content
x_Transferable = x_Clipboard~getContents()

/*
check if the clipboard object contains text information:
get a list of all supported data types
and search for a valid entry (utf-16)
*/

flavorslist = x_Transferable~getTransferDataFlavors()
flavorslistlength = bsf('arrayLength', flavorslist)
counter = 1
found = false;
do while (counter <= flavorslistlength) & (found = false)
  found = (flavorslist[counter]~bsf.getFieldValue("MimeType") = "text/plain;charset=utf-16")
  counter = counter + 1
end

-- if it contains a valid entry:
if found then
do
  counter = counter - 1
  -- create a data type converter service
  s_Converter = x_MultiServiceFactory~createInstance("com.sun.star.script.Converter")
  x_TypeConverter = s_Converter~XTypeConverter

  -- transform data (into simple text)
  content = x_Transferable~getTransferData(flavorslist[counter])

  -- read clipboard as string
  stringtype = bsf.getConstant("com.sun.star.uno.TypeClass", "STRING")  
  cliptext = x_TypeConverter~convertToSimpleType(content, stringtype)

end

-- add the current date to the previously recieved text
cliptext = cliptext || DATE("E",,,".")

-- and write down this information at the current textcursor position
x_TextDocument = x_Document~XTextDocument
x_Text = x_TextDocument~getText

s_CurrentController = x_TextDocument~getCurrentController()
x_TextViewCursorSupplier = s_CurrentController~XTextViewCursorSupplier
x_CurrentCursor = x_TextViewCursorSupplier~getViewCursor()

x_TextCursor = x_Text~createTextCursorByRange(x_CurrentCursor~getStart())

x_SimpleText = x_Text~XSimpleText
x_SimpleText~insertString(x_TextCursor, cliptext, .false)

::requires UNO.CLS