-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first we search all paragraph styles if there is allready one
-- with name "code"
x_StyleFamiliesSupplier = x_Document~XStyleFamiliesSupplier
x_StyleFamilies = x_StyleFamiliesSupplier~getStyleFamilies()
s_StyleFamily = x_StyleFamilies~getByName("ParagraphStyles")

x_NameAccess = s_StyleFamily~XNameAccess

if x_NameAccess~hasByName("code") then
do
   -- if "code" allready exists show error message
   .bsf.dialog~messageBox('PageStyle "code" allready exists!', "ERROR", "error")
end
else
do
   -- if "code" does not exist:

   -- create a factory to create a new paragraph style object
   x_MultiServiceFactory = x_Document~XMultiServiceFactory
   s_ParagraphStyle = x_MultiServiceFactory~createInstance("com.sun.star.style.ParagraphStyle")

   -- now set its properties
   s_ParagraphProperties = s_ParagraphStyle~XPropertySet

   -- WARNING! Java.Integer = UNO_LONG !!!!!!!
   -- its background color
   paracolor = .bsf~new("java.lang.Integer", X2D("FFFFCC"))
   s_ParagraphProperties~setPropertyValue("ParaBackColor", paracolor)

   -- left and right margin
   pramargin = .bsf~new("java.lang.Integer", 500)
   s_ParagraphProperties~setPropertyValue("ParaLeftMargin", pramargin)
   s_ParagraphProperties~setPropertyValue("ParaRightMargin", pramargin)

   -- left, right, top and bottom border
   o_Border = .bsf~new("com.sun.star.table.BorderLine")
   o_Border~bsf.setFieldValue("Color", 0)
   o_Border~bsf.setFieldValue("InnerLineWidth", 0)
   o_Border~bsf.setFieldValue("OuterLineWidth", 1)
   o_Border~bsf.setFieldValue("LineDistance", 0)

   s_ParagraphProperties~setPropertyValue("LeftBorder", o_Border)
   s_ParagraphProperties~setPropertyValue("RightBorder", o_Border)
   s_ParagraphProperties~setPropertyValue("TopBorder", o_Border)
   s_ParagraphProperties~setPropertyValue("BottomBorder", o_Border)

   borderdist = .bsf~new("java.lang.Integer", 50)
   s_ParagraphProperties~setPropertyValue("LeftBorderDistance", borderdist)
   s_ParagraphProperties~setPropertyValue("RightBorderDistance", borderdist)
   s_ParagraphProperties~setPropertyValue("TopBorderDistance", borderdist)
   s_ParagraphProperties~setPropertyValue("BottomBorderDistance", borderdist)

   -- and the fontname
   s_ParagraphProperties~setPropertyValue("CharFontName", "Arial")

   -- finally insert the new paragraph style to the list of
   -- paragraph styles of this document
   x_NameAccess~insertByName("code", s_ParagraphStyle)
end

::requires UNO.CLS