-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first we define a locale entry that is unknown
st_Locale = .bsf~new("com.sun.star.lang.Locale")
st_Locale~bsf.setFieldValue("Language", "unknown")
st_Locale~bsf.setFieldValue("Country", "unknown")

-- next we get the text interface of the document
x_TextDocument = x_Document~XTextDocument
x_Text = x_TextDocument~getText

-- now we create a virtual text cursor and a paragraphcursor interface of it.
x_TextCursor = x_Text~createTextCursor()
x_ParagraphCursor = x_TextCursor~XParagraphCursor

-- here we go to the start of the document
x_TextCursor~gotoStart(.false)

-- now we jump from one paragraph to the next one and change its locale entry
do while x_ParagraphCursor~gotoNextParagraph(.true)
   x_PropertySet = x_TextCursor~XPropertySet
   x_PropertySet~setPropertyValue("CharLocale", st_Locale)
   x_ParagraphCursor~goRight(0, .false)
end

-- finally we check if there is also text behind the last paragraph.
-- their language also must be changed
if x_ParagraphCursor~gotoEndOfParagraph(.false) then
do
   x_ParagraphCursor~goRight(1, .false)
   x_ParagraphCursor~gotoEnd(.true)
   x_PropertySet = x_TextCursor~XPropertySet
   x_PropertySet~setPropertyValue("CharLocale", st_Locale)
   x_ParagraphCursor~goRight(0, .false)
end

::requires UNO.CLS