-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first we create a folder dialog to select the export folder
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
folderpicker = "com.sun.star.ui.dialogs.OfficeFolderPicker"
s_FolderDialog = x_MultiServiceFactory~createInstance(folderpicker)
x_FolderDialog = s_FolderDialog~XFolderPicker

-- change the displayed text
x_FolderDialog~setDescription("Select Directory to Export Graphics")

pathchoosen = x_FolderDialog~execute()
if ( pathchoosen ) then
do
   -- if a path was sucessfully choosen read the path
   exportpath = x_FolderDialog~getDirectory()

   /*
   now get a text graphics Supplier interface to access all
   the graphics within our text. The function returns a name access
   container but we will use an indexed access.
   */
   x_TextGraphicObjectsSupplier = x_Document~XTextGraphicObjectsSupplier
   x_NameAccess = x_TextGraphicObjectsSupplier~getGraphicObjects()
   x_IndexAccess = x_NameAccess~XIndexAccess

   -- next we create a Graphicprovider service (to write graphic files)
   graphicprovider = "com.sun.star.graphic.GraphicProvider"
   s_GraphicProvider = x_MultiServiceFactory~createInstance(graphicprovider)
   x_GraphicProvider = s_GraphicProvider~XGraphicProvider

   -- now we iterate trough the text graphic supplier and export all graphics
   arr = uno.CreateArray(.UNO~PROPERTYVALUE, 2)

   amount = x_IndexAccess~getCount()

   do counter = 1 to amount

      -- here we define the type of graphics and the storage path and filename
      arr[1] = uno.createProperty("MimeType", "image/jpeg")
      pictureurl = exportpath || "/" || "picture" || counter || ".jpg"
      arr[2] = uno.createProperty("URL", pictureurl)

      -- retrieve the picture object
      o_Picture = x_IndexAccess~getByIndex(counter - 1)

      -- next read the picture data and get a XGraphic interface of it
      x_TextGrapicPropertySet = o_Picture~XPropertySet
      o_Graphic = x_TextGrapicPropertySet~getPropertyValue("Graphic")
      x_Graphic = o_Graphic~XGraphic

      -- finally store the picture
      x_GraphicProvider~storeGraphic(x_Graphic, arr)
   end
end

::requires UNO.CLS