-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first we get access to the textdocument and its text object
x_TextDocument = x_Document~XTextDocument
x_Text = x_TextDocument~getText

-- get the current current cursor
s_CurrentController = x_TextDocument~getCurrentController()
x_TextViewCursorSupplier = s_CurrentController~XTextViewCursorSupplier
x_CurrentCursor = x_TextViewCursorSupplier~getViewCursor()

-- get access to the properties of the current cursor and retrieve
-- name of the current pagestyle
cursorproperties = x_CurrentCursor~XPropertySet
pagestylename = cursorproperties~getPropertyValue("PageStyleName")

-- next we search the StyleFamily entries for our current pagestyle
x_StyleFamiliesSupplier = x_Document~XStyleFamiliesSupplier
x_StyleFamilies = x_StyleFamiliesSupplier~getStyleFamilies()
s_StyleFamily = x_StyleFamilies~getByName("PageStyles")
x_NameAccess = s_StyleFamily~XNameAccess
s_PageProperties = x_NameAccess~getByName(pagestylename)

-- get the properties of the current page
pageproperties = s_PageProperties~XPropertySet

-- get the current status of header and footer of this page
oldheader = pageproperties~getPropertyValue("HeaderIsOn")
oldfooter = pageproperties~getPropertyValue("FooterIsOn")

-- if header is on turn it of and vice versa
-- i dont know why disabling needs a complet object as parameter, but
-- enabling does not. (enabling wont work if using objects)

if oldheader then pageproperties~setPropertyValue("HeaderIsOn", .bsf~new("java.lang.Boolean", 0))
else pageproperties~setPropertyValue("HeaderIsOn", 1)

if oldfooter then pageproperties~setPropertyValue("FooterIsOn", .bsf~new("java.lang.Boolean", 0))
else pageproperties~setPropertyValue("FooterIsOn", 1)

::requires UNO.CLS