-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first check if paragraph style "code" is present 
x_StyleFamiliesSupplier = x_Document~XStyleFamiliesSupplier
x_StyleFamilies = x_StyleFamiliesSupplier~getStyleFamilies()
s_StyleFamily = x_StyleFamilies~getByName("ParagraphStyles")
x_NameAccess = s_StyleFamily~XNameAccess

if \ x_NameAccess~hasByName("code") then
do
   -- if style is not present
   .bsf.dialog~messageBox('Paragraph Style "code" does not exist!', "ERROR", "error")
end
else
do
   -- if style is present:
   -- ask for filename using the file dialog
   x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
   s_FileDialog = x_MultiServiceFactory~createInstance("com.sun.star.ui.dialogs.OfficeFilePicker")
   x_FileDialog = s_FileDialog~XFilePicker
   x_FileDialogFilters = s_FileDialog~XFilterManager

   -- adding some file extensions to the dialog
   x_FileDialogFilters~appendFilter("OORexx *.rex", "*.rex")
   x_FileDialogFilters~appendFilter("C++ *.cpp", "*.cpp")
   x_FileDialogFilters~appendFilter("All *.*", "*.*")

   -- Better name for our dialog:
   x_FileDialog~setTitle("Select Code File")

   -- selecting more than one file at once dissalowed (to allow it use 1)
   x_FileDialog~setMultiSelectionMode(0)

   -- run dialog
   filechoosen = x_FileDialog~execute()
   if ( filechoosen ) then
   do
      -- if dialog button ok pressed read filename
      file = x_FileDialog~getFiles()
      codefileurl = file[1]
      codefile = uno.convertFromUrl(codefileurl)

      -- set up gvim command
      command = 'gvim ' || codefile || ' -n -c "runtime! syntax/2html.vim" -c wq -c q'

      -- find out which operating system is present and set up the shell execution
      /* Normally ooRexx is able to determine the operating system itself. But calling
         the macro with rexxj or inside Open Office disables this ability.*/
      if .uno~path.separator=";" then
      do
         -- Windows
         ADDRESS CMD
      end
      else
      do
         -- Linux
         shell=value("SHELL",,"ENVIRONMENT") -- get type of shell
         shell=substr(shell, shell~lastpos("/")+1) -- get shell name
         ADDRESS VALUE shell           -- set shell as command shell
      end

      -- execute command
      command
  
      htmlfileurl = codefileurl || ".html"

      -- import html file at cursor postion
      x_TextDocument = x_Document~XTextDocument
      x_Text = x_TextDocument~getText

      s_CurrentController = x_TextDocument~getCurrentController()
      x_TextViewCursorSupplier = s_CurrentController~XTextViewCursorSupplier
      x_CurrentCursor = x_TextViewCursorSupplier~getViewCursor()

      x_TextCursor = x_Text~createTextCursorByRange(x_CurrentCursor~getStart())

      -- html insertion interface
      x_DocumentInsertable = x_TextCursor~XDocumentInsertable

      -- current cursor position (and paragraph style)     
      x_CursorPropertySet = x_TextCursor~XPropertySet
      oldstyle = x_CursorPropertySet~getPropertyValue("ParaStyleName")

      -- change pararaph style
      x_CursorPropertySet~setPropertyValue("ParaStyleName", "code")

      -- now insert the html file

      /*
      Create a property array.
      Parameter 2 means it has a capacity of two elements
      (if parameter is set to 0 it is not .nil!, but an empty java array).
      */

      properties = uno.CreateArray(.UNO~PROPERTYVALUE, 1)

      properties[1] = uno.createProperty("FilterName", "HTML (StarWriter)")

      x_DocumentInsertable~insertDocumentFromURL(htmlfileurl, properties)

      -- create new paragraph and return to old style
      x_Text~insertControlCharacter(x_TextCursor, 5, .false)
      x_CursorPropertySet~setPropertyValue("ParaStyleName", oldstyle)
   end
end

::requires UNO.CLS