-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- this macro just works externally, called by rexxj or rexx

-- create DispatchHelper service and query its interface
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
s_DispatchHelper = x_MultiServiceFactory~createInstance("com.sun.star.frame.DispatchHelper")
x_DispatchHelper = s_DispatchHelper~XDispatchHelper

-- get dispatch provider interface of current Desktop
x_DispatchProvider = x_Desktop~XDispatchProvider
-- define ooRexx dispatch target
MacroURL = "vnd.sun.star.script:BakkMacros.x_Sample.rex?language=ooRexx&location=user"

-- prepare parameters
parameters = uno.CreateArray(.UNO~PROPERTYVALUE, 2)
-- traget script ignores argument names, use any name you want
parameters[1] = uno.createProperty("arg1", 5)
parameters[2] = uno.createProperty("arg2", 2)

-- make dispatch call
-- ATTENTION! do not use .nil here, instead use .uno~noProps if no parameters submitted !!!
-- i.e: x_DispatchHelper~executeDispatch(x_DispatchProvider, MacroURL, "", 0, .uno~noProps)
r = x_DispatchHelper~executeDispatch(x_DispatchProvider, MacroURL, "", 0, parameters)

.bsf.dialog~messageBox("Result of x_Sample.rex: " || r~result, "IT Works", "information")

-- define Star Basic dispatch target
MacroURL = "vnd.sun.star.script:BakkMacros.x_Sample.addition?language=Basic&location=application"

-- r = x_DispatchHelper~executeDispatch(x_DispatchProvider, MacroURL, "", 0, .uno~noProps)
r = x_DispatchHelper~executeDispatch(x_DispatchProvider, MacroURL, "", 0, parameters)

.bsf.dialog~messageBox("Result of x_Sample.addition (Star Basic Macro): " || r~result, -
"IT Works", "information")

::requires UNO.CLS