-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first we need a file dialog to select a file to import
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
s_FileDialog = x_MultiServiceFactory~createInstance("com.sun.star.ui.dialogs.OfficeFilePicker")
x_FileDialog = s_FileDialog~XFilePicker
x_FileDialogFilters = s_FileDialog~XFilterManager

-- adding some file extensions
x_FileDialogFilters~appendFilter("All *.*", "*.*")

-- Better name for our dialog:
x_FileDialog~setTitle("Select Graphic File")

-- selecting more than one file at once dissalowed (to allow it use 1)
x_FileDialog~setMultiSelectionMode(0)

filechoosen = x_FileDialog~execute()
if ( filechoosen ) then
do
   -- if a file has been choosen:
   -- read filename
   files = x_FileDialog~getFiles()
   file = files[1]

   -- now get the currently slected sheet
   x_Model = x_Document~XModel
   s_CurrentController = x_Model~getCurrentController()
   x_View = s_CurrentController~XSpreadsheetView
   x_Spreadsheet = x_View~getActiveSheet()

   -- and the drawing interface from this sheet
   x_DrawPageSupplier = x_Spreadsheet~XDrawPageSupplier
   x_DrawPage = x_DrawPageSupplier~getDrawPage()

   -- next create a Graphics object (a Shape)
   x_MultiServiceFactory = x_Document~XMultiServiceFactory
   s_Shape = x_MultiServiceFactory~createInstance("com.sun.star.drawing.GraphicObjectShape")
   shapeProperties = s_Shape~XPropertySet

   -- and enter the filename to the link --> JUST A LINKED GRAPHIC!
   shapeProperties~setPropertyValue("GraphicURL", file)

   -- enlarge and reposition the graphical object
   size = .bsf~new("com.sun.star.awt.Size")
   size~bsf.setFieldValue("width", 5535)
   size~bsf.setFieldValue("height", 5535)

   pos = .bsf~new("com.sun.star.awt.Point")
   pos~bsf.setFieldValue("X", 400)
   pos~bsf.setFieldValue("Y", 400)

   x_Shape = s_Shape~XShape
   x_Shape~setSize(size)
   x_Shape~setPosition(pos)

   -- finally add the graphics object to the sheet
   x_DrawPage~add(x_Shape)
end


::requires UNO.CLS
