-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




/*
first we need to get the currently selected cell in the currently
selected sheet. If more than one cell is selected we first have to
reduce the amount of selected cells to only one, otherwise an error
occurs.
*/

-- query a list of spreadsheets (used later)
x_SpreadsheetDocument = x_Document~XSpreadsheetDocument
x_Spreadsheets = x_SpreadsheetDocument~getSheets()
x_SpreadsheetIA = x_Spreadsheets~XIndexAccess

-- now get the current selection
x_Model = x_Document~XModel
currentselection = x_Model~getCurrentSelection()

-- now  create a new selection object with only one cell selected
s_CurrentController = x_Model~getCurrentController()
x_MultiServiceFactory = x_Document~XMultiServiceFactory
newselection = x_MultiServiceFactory~createInstance("com.sun.star.sheet.SheetCellRanges")

-- use the new selection on the current sheet
x_View = s_CurrentController~XSelectionSupplier
x_View~select(newselection)

-- get the currently selected cell and its address
noselectioncell = x_Model~getCurrentSelection()

x_CellAddressable = noselectioncell~XCellAddressable
st_CellAddress = x_CellAddressable~getCellAddress()

-- restore old selection
x_View~select(currentselection)

-- get position of current cell and query cell object
currentcell.sheet = st_CellAddress~bsf.getFieldValue("Sheet")
currentcell.column = st_CellAddress~bsf.getFieldValue("Column")
currentcell.row = st_CellAddress~bsf.getFieldValue("Row")

s_Spreadsheet = x_SpreadsheetIA~getByIndex(currentcell.sheet)
x_Spreadsheet = s_Spreadsheet~XSpreadsheet

cell = uno.getCell(x_Spreadsheet, currentcell.column, currentcell.row)

-- create text interface on cell
x_TextRange = cell~XTextRange
x_Text = x_TextRange~getText()

-- read cell textcontent
urlstring = x_Text~getString()

-- create url field
s_urlfield = x_MultiServiceFactory~createInstance("com.sun.star.text.TextField.URL")
urlproperties = s_urlfield~XPropertySet
urlproperties~setPropertyValue("Representation", urlstring)
urlproperties~setPropertyValue("URL", urlstring)

-- clear cell and write urlfield
x_TextContent = s_urlfield~XTextContent
x_Text~setString("")
x_Text~insertTextContent(x_Text~createTextCursor(), x_TextContent, .false)

::requires UNO.CLS