-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- define where to store the toolbar
ToolbarURL = "private:resource/toolbar/custom_exampletoolbar"

-- get the user interface configuration
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
configsupplier = "com.sun.star.ui.ModuleUIConfigurationManagerSupplier"
s_Supplier = x_MultiServiceFactory~createInstance(configsupplier)
x_Supplier = s_Supplier~XModuleUIConfigurationManagerSupplier

-- the document type this toolbar is bound to
DocumentType = "com.sun.star.text.TextDocument"

-- get the user interface configuration of writer
x_UIConfigurationManager = x_Supplier~getUIConfigurationManager(DocumentType)

-- create a new toolbar for writer  
x_IndexContainer = x_UIConfigurationManager~createSettings()

-- configure toolbar
-- set name of toolbar
x_Propertyset = x_IndexContainer~XPropertySet
x_Propertyset~setPropertyValue("UIName", "Bakk Statusbar")

-- configure toolbar element
DefaultButton = bsf.getConstant("com.sun.star.ui.ItemType", "DEFAULT")

toolbarbutton = uno.CreateArray(.UNO~PROPERTYVALUE, 4)

MacroURL = "vnd.sun.star.script:BakkMacros.w_CreateStyleCode.rex?language=ooRexx&location=user:uno_packages/BakkMacros.oxt"
toolbarbutton[1] = uno.createProperty("CommandURL", MacroURL)
toolbarbutton[2] = uno.createProperty("Label", "Create Style: code")
toolbarbutton[3] = uno.createProperty("Type", DefaultButton)
toolbarbutton[4] = uno.createProperty("Visible", .true)

-- add toolbar element
x_IndexContainer~insertByIndex(0, toolbarbutton)

-- configure another toolbar element
MacroURL = "vnd.sun.star.script:BakkMacros.w_ImportCode.rex?language=ooRexx&location=user:uno_packages/BakkMacros.oxt"
toolbarbutton[1] = uno.createProperty("CommandURL", MacroURL)
toolbarbutton[2] = uno.createProperty("Label", "Import Code from GVim")
toolbarbutton[3] = uno.createProperty("Type", DefaultButton)
toolbarbutton[4] = uno.createProperty("Visible", .true)

-- and add it at second position
x_IndexContainer~insertByIndex(1, toolbarbutton)

-- if the toolbar allready exists replace it, otherwise add it to the user interface
If x_UIConfigurationManager~hasSettings(ToolbarURL) then
do
   x_UIConfigurationManager~replaceSettings( ToolbarURL, x_IndexContainer )
end
else
do
   x_UIConfigurationManager~insertSettings( ToolbarURL, x_IndexContainer )
end

::requires UNO.CLS