-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- first we create an instance of the configurationprovider
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
configprovider = "com.sun.star.configuration.ConfigurationProvider"
s_ConfigProvider = x_MultiServiceFactory~createInstance(configprovider)
x_ConfigFactory = s_ConfigProvider~XMultiServiceFactory

-- this strig tells the provider to give us reading access to the configuration
conf = "com.sun.star.configuration.ConfigurationAccess"

-- here we define the path to the language information
args = uno.CreateArray(.UNO~PROPERTYVALUE, 1)

args[1] = uno.createProperty("nodepath", "/org.openoffice.Setup/L10N")

-- finally we request configuration access to the predefined configurationpath
s_ConfigurationAccess = x_ConfigFactory~createInstanceWithArguments(conf, args)
x_NameAccess = s_ConfigurationAccess~XNameAccess

-- and read one of its entries
locale = x_NameAccess~getByName("ooLocale")

-- next we try to read another configuration entry:

args[1]~value = "/org.openoffice.Setup/Product"

s_ConfigurationAccess = x_ConfigFactory~createInstanceWithArguments(conf, args)
x_NameAccess = s_ConfigurationAccess~XNameAccess

version = x_NameAccess~getByName("ooSetupVersion")

-- this is a carriage return line feed string to jump into the next
-- line when displaying our information
crlf = "13"~d2c || "10"~d2c

-- combine outputs
output = "Open Office: " || crlf || "Version: " || version || crlf || "Language: " || locale

-- show message
.bsf.dialog~messageBox(output, "About:", "information")

::requires UNO.CLS