-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- define toolbar storage position
ToolbarURL = "private:resource/toolbar/custom_exampletoolbar"

-- create the user interface supplier
x_MultiServiceFactory = x_ComponentContext~getServiceManager()~XMultiServiceFactory
configsupplier = "com.sun.star.ui.ModuleUIConfigurationManagerSupplier"
s_Supplier = x_MultiServiceFactory~createInstance(configsupplier)
x_Supplier = s_Supplier~XModuleUIConfigurationManagerSupplier

-- Specify the document type (writer)
DocumentType = "com.sun.star.text.TextDocument"

-- next get the manager
x_UIConfigurationManager = x_Supplier~getUIConfigurationManager(DocumentType)
  
-- check if such a toolbar exists
If x_UIConfigurationManager~hasSettings(ToolbarURL) then
do
   -- if it exists remove it
   x_UIConfigurationManager~removeSettings(ToolbarURL)
   .bsf.dialog~messageBox("Toolbar removed", "RemoveToolbar.rex", "information")
end
else
do
   -- outherwise just send error message
   .bsf.dialog~messageBox("Toolbar not installed", "RemoveToolbar.rex", "error") 
end

::requires UNO.CLS