-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- create interface for text document
x_TextDocument = x_Document~XTextDocument
-- get a text object of text document
x_Text = x_TextDocument~getText

-- get the current cursor position
s_CurrentController = x_TextDocument~getCurrentController()
x_TextViewCursorSupplier = s_CurrentController~XTextViewCursorSupplier
x_CurrentCursor = x_TextViewCursorSupplier~getViewCursor()

-- create a textcursor of it
x_TextCursor = x_Text~createTextCursorByRange(x_CurrentCursor~getStart())

-- now create a factory that is able to add datetime objects to the document
x_MultiServiceFactory = x_Document~XMultiServiceFactory
s_DateTime = x_MultiServiceFactory~createInstance("com.sun.star.text.TextField.DateTime")

-- next configure the new date time object
x_DateTimeProperties = s_DateTime~XPropertySet
x_DateTimeProperties~setPropertyValue("IsFixed", .bsf~new("java.lang.Boolean", .true))
x_DateTimeProperties~setPropertyValue("IsDate", .bsf~new("java.lang.Boolean", .true))

-- next create a number formats suppliere to get
-- access to the various automatic number formats
x_NumberFormatsSupplier = x_Document~XNumberFormatsSupplier
x_NumberFormats = x_NumberFormatsSupplier~getNumberFormats()

-- define the language settings to use to search for entries
st_Locale = .bsf~new("com.sun.star.lang.Locale")
st_Locale~bsf.setFieldValue("Language", "en")
st_Locale~bsf.setFieldValue("Country", "USA")

-- look out for the existance of our number format, if none exists, create one.
format ="DD.MM.YY"
formatindex = x_NumberFormats~queryKey(format, st_Locale, .true)
If formatindex = -1 then formatindex = x_NumberFormats~addNew(format, st_Locale)


-- now set the format of the date time object
val = .bsf~new("java.lang.Integer", formatindex)

x_DateTimeProperties~setPropertyValue("NumberFormat", val)

-- finally add the date time object to the text
x_TextContent = s_DateTime~XTextContent
x_Text~insertTextContent(x_TextCursor, x_TextContent, .true)

::requires UNO.CLS