-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- final output
output = "Text: "

-- get the current selection
x_Model = x_Document~XModel
s_Container = x_Model~getCurrentSelection()

if s_Container <> .nil then
do
   -- if there is a selection iterate trough the selection
   -- and read out the text into output variable
   
   x_IndexAccess = s_Container~XIndexAccess
   size = x_IndexAccess~getCount()

   do counter = 1 to size
      s_text = x_IndexAccess~getByIndex(counter - 1)
      x_TextRange = s_text~XTextRange

      output = output || x_TextRange~getString()
   end
end

-- finally show what is selected
.bsf.dialog~messageBox(output, "Currently Selected Text:", "information")

::requires UNO.CLS