-- try to get a script context, will be .nil, if script was not invoked by OOo
x_ScriptContext = uno.getScriptContext()
if (x_ScriptContext <> .nil) then
do
   -- invoked by OOo as a macro

   -- get context
   x_ComponentContext = x_ScriptContext~getComponentContext
   -- get desktop (an XDesktop)
   x_Desktop  = x_ScriptContext~getDesktop
   -- get current document
   x_Document = x_ScriptContext~getDocument
end
else  
do
   -- called from outside of OOo, create a connection

   -- connect to Open Office and get component context
   x_ComponentContext = UNO.connect()
   -- create a desktop service and its interface
   service = "com.sun.star.frame.Desktop"
   s_Desktop = x_ComponentContext~getServiceManager~XMultiServiceFactory~createInstance(service)
   x_Desktop = s_Desktop~XDesktop
   -- get the last active document
   x_Document = x_Desktop~getCurrentComponent()  
end




-- get the text of the current document
x_TextDocument = x_Document~XTextDocument
x_Text = x_TextDocument~getText

-- get the current cursor position
s_CurrentController = x_TextDocument~getCurrentController()
x_TextViewCursorSupplier = s_CurrentController~XTextViewCursorSupplier
x_CurrentCursor = x_TextViewCursorSupplier~getViewCursor()

-- get current text cursor
x_TextCursor = x_Text~createTextCursorByRange(x_CurrentCursor~getStart())

-- create a factory to create a note object
x_MultiServiceFactory = x_Document~XMultiServiceFactory
s_Annotation = x_MultiServiceFactory~createInstance("com.sun.star.text.TextField.Annotation")

-- get access to the note object properties and fill them
x_AnnotationProperties = s_Annotation~XPropertySet
x_AnnotationProperties~setPropertyValue("Author", "JF")
x_AnnotationProperties~setPropertyValue("Content", "Thats right, Mr. Pitonyak")

-- get current date from rexx and parse, year month and day
currentdate = DATE("S",,,"/")
PARSE VAR currentdate year "/" month "/" day

-- create date object and set its date properties, then add the date object
-- to the note object
date = .bsf~new("com.sun.star.util.Date")
date~bsf.setFieldValue("Day", day)
date~bsf.setFieldValue("Month", month)
date~bsf.setFieldValue("Year", year)
x_AnnotationProperties~setPropertyValue("Date", date)

-- finally insert the note object into the text
x_TextContent = s_Annotation~XTextContent
x_Text~insertTextContent(x_TextCursor, x_TextContent, .true)

::requires UNO.CLS