xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

/*retrieve the current selections*/
oController = xdoc~XModel~getCurrentController()
oSelections = oController~XSelectionSupplier~getSelection()

/*object existent? - might happen for Draw, Impress etc.*/
if oSelections ==.nil then
do
	.bsf.dialog~messageBox("Nothing selected.")
	EXIT
end

/*access all selections*/
aSupportedInterfaces = uno.getInterfaceNamesViaReflection(oSelections)~makeArray(" ")
s = "Selection is of type" 

/*possibilities: Text, Table Cells, Text Frame, Graphic Object, OLE Object, Shape*/
/*is text? - supports XIndexAccess*/
if aSupportedInterfaces~hasItem("com.sun.star.container.XIndexAccess") then
do
	s = s "text." .ENDOFLINE
	anythingSelected = .false
	xIndexAccess = oSelections~XIndexAccess
	size = xIndexAccess~getCount()
	if size== 0 then
	do
		.bsf.dialog~messageBox("Nothing selected.")
		EXIT
	end
	/*ok, let's have a closer look on the selections*/
	counter = 1
	do i=1 to size 
		oSel = xIndexAccess~getByIndex(i-1)
		oCursor = oSel~XTextRange~getText()~createTextCursorByRange(oSel~XTextRange)
		if oCursor~isCollapsed() == .false then
		do
			anythingSelected = .true
			s = s counter||"." oSel~XTextRange~getString() .ENDOFLINE
			counter = counter+1
		end
	end

	if \ anythingSelected then
	do
		.bsf.dialog~messageBox("Nothing selected. Only cursor. Exiting.")
		EXIT
	end
end
else if uno.supportsService(oSelections,"com.sun.star.drawing.ShapeCollection") then
do
	iSelCount = oSelections~XShapes~XIndexAccess~getCount()
	s = s "shape." .ENDOFLINE
	s = s iSelCount "shape(s) selected." .ENDOFLINE
	aTypes = .table~new()
	do i=1 to iSelCount
		oShape = oSelections~XShapes~XIndexAccess~getByIndex(i-1)
		sType = oShape~XShapeDescriptor~getShapeType()
		if aTypes~hasIndex(sType) then
			aTypes~put(aTypes~at(sType)+1,sType)
		else
			aTypes~put(1,sType)
	end
	aIndexes = aTypes~allIndexes
	
	s = s "These are of types" .ENDOFLINE
	do i=1 to aIndexes~items
		item = aIndexes~at(i)
		s = s item||":" aTypes~at(item) .ENDOFLINE
	end
end
else if uno.supportsService(oSelections,"com.sun.star.text.TextTableCursor") then
do
	s = s "text table cells." .ENDOFLINE
	s = s "Range selected:" oSelections~XTextTableCursor~getRangeName()
end
else if uno.supportsService(oSelections,"com.sun.star.text.TextEmbeddedObject") then
do
	s= s "embedded object." .ENDOFLINE
	s= s||"Class Identifier:" oSelections~XPropertySet~getPropertyValue("CLSID")
end
else if uno.supportsService(oSelections,"com.sun.star.text.TextFrame") then
do
	s = s "text frame." .ENDOFLINE
	s = s||"Text:" .ENDOFLINE
	s = s||oSelections~XTextFrame~getText()~getString()
end
else if uno.supportsService(oSelections,"com.sun.star.text.TextGraphicObject") then
do
	s = s "graphic." .ENDOFLINE
	s = s "Its URL is" oSelections~XPropertySet~getPropertyValue("GraphicURL")||"."
end
else
do
	s = s "unknown."
end


.bsf.dialog~messageBox(s)

::requires UNO.cls

