xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

/*get the text*/
oText = xDoc~XTextDocument~getText()
xController = xDoc~XModel~getCurrentController()

/*get the view cursor to determine line ends*/
oViewCursor = xController~XTextViewCursorSupplier~getViewCursor()

/*get the paragraph text cursor to determine paragraph ends*/
oTextCursor = oText~createTextCursorByRange(oViewCursor)~XParagraphCursor

/*we want to restore the view cursor afterwards*/
oSaveCursor = oText~createTextCursorByRange(oViewCursor)

/*move cursor to start of current paragraph to process the whole*/
if \ oTextCursor~isStartOfParagraph() then
do
	oTextCursor~gotoStartOfParagraph(.false)
	oViewCursor~gotoRange(oTextCursor,.false)
end

/*for each line in paragraph*/
do forever 
	/*the view cursor now knows where the line ends*/
	oViewCursor~XLineCursor~gotoEndOfLine(.false)

	/*check whether the end of the paragraph has been reached - then exit*/
	oTextCursor~gotoRange(oViewCursor,.false)

	if oTextCursor~isEndOfParagraph() then do
		/*end of paragraph reached - exit*/
		leave
	end
	else do
		/*if not - insert a linebreak*/
		oText~insertControlCharacter(oViewCursor,bsf.getConstant("com.sun.star.text.ControlCharacter","LINE_BREAK"),.false)
		oViewCursor~goRight(1,.false)

	end
end	

/*restore the view cursor position*/
oViewCursor~gotoRange(oSaveCursor,.false)


/*load module*/
::requires UNO.CLS


