xsc = uno.getScriptContext()
if (xsc <> .nil) then
do
-- invoked by OOo as a macro
xcc = xsc~getComponentContext
-- get desktop (an XDesktop)
xdt = xsc~getDesktop
-- get current document
xdoc = xsc~getDocument
end
else
do
-- called from outside of OOo, create a connection
xcc = UNO.connect()
-- create a desktop service and its interface
service = "com.sun.star.frame.Desktop"
s_Desktop = xcc~getServiceManager~XMultiServiceFactory~createInstance(service)
xdt = s_Desktop~XDesktop
xdoc = xdt~getCurrentComponent()
end

/*check if anything is selected*/
oSelection = xdoc~XModel~getCurrentSelection()

xIndexAccess = oSelection~XIndexAccess
size = xIndexAccess~getCount()

oSelection_noncollapsed = .array~new

/*check whether the selections are collapsed - we use a text cursor that covers the range*/
do i=1 to size
	oSel = xIndexAccess~getByIndex(i-1)~XTextRange
	oCursor = xdoc~XTextDocument~getText()~createTextCursorByRange(oSel)
	if \ oCursor~isCollapsed() then
	do
		oSelection_noncollapsed~append(oSel)
	end
end

/*if we have no uncollapsed selection, we take the whole document as selection*/
if oSelection_noncollapsed~items == 0 then
do
	if .bsf.dialog~dialogBox("No selection found. Traverse whole document?", ,"Warning","YesNo") then
		EXIT

	xDocTextRange = xdoc~XTextDocument~getText()~XTextRange

	if \ xdoc~XTextDocument~getText()~createTextCursorByRange(xDocTextRange)~isCollapsed then
		oSelection_noncollapsed~append(xDocTextRange)
	else
	do
		.bsf.dialog~messageBox("You seem to have provided an empty text. Exiting.")
		EXIT
	end
end

/*we now check all XTextRanges in the oSelection_noncollapsed array for white spaces*/
/*note that for clarity we don't perform a direction check here for the XTextRanges introduced in example 03, although it would be useful*/
size = oSelection_noncollapsed~items
do i=1 to size
	oSel = oSelection_noncollapsed~at(i)
	/*obtain a text cursor over the range*/
	oLeftRange = oSel~getStart()
	oRightRange = oSel~getEnd()
	oLeftCursor = xdoc~XTextDocument~getText~createTextCursorByRange(oLeftRange)
	oRightCursor = xdoc~XTextDocument~getText~createTextCursorByRange(oRightRange)
	/*go to start of cursor and "initialize" it*/
	oLeftCursor~collapseToStart()
	oLeftCursor~goRight(0,.false)

	/*we now set the first ASCII character*/
	oLeftCursor~goRight(1,.true)
	iPrevious = oLeftCursor~XTextRange~getString()
	iPrevious = convertToASCII(iPrevious)
	

	/*collapse the selection to the end
	 *this is save for the first time, as the selection is >0, thus at least 1*/
	oLeftCursor~collapseToEnd()

	/*traverse through the rest of the selection*/
	do while xdoc~XTextDocument~getText()~XTextRangeCompare~compareRegionEnds(oLeftCursor~XTextRange, oRightCursor~XTextRange)
		oLeftCursor~goRight(1,.true)
		iCurrent = oLeftCursor~XTextRange~getString()
		iCurrent = convertToASCII(iCurrent)
		/*let's get the rank results*/
		toDel = rankChar(iPrevious iCurrent)
		/*if we get a result, delete the specific character of lower importance*/
		if toDel<>0 then
		do
			if toDel==1 then
			do
				/*delete the current character*/
				oLeftCursor~XTextRange~setString("")
			end
			else
			do
				/*delete the previous character*/
				oLeftCursor~goLeft(2,.true)
				oLeftCursor~XTextRange~setString("")
				oLeftCursor~goRight(1,.false)
				iPrevious = iCurrent
			end
		end
		else
		do
			iPrevious = iCurrent
			oLeftCursor~collapseToEnd()
		end
	end
end


::REQUIRES UNO.cls

::ROUTINE convertToASCII
	PARSE ARG ascii
	/*it is possible that the retrieved string is length zero - e.g. if an image is selected - or of length x>1 if a field is selected
	 *as did Pitonyak, we then set the value to 65*/
	if ascii~length <> 1 then
		ascii = 65
	else
		ascii = c2d(ascii)

RETURN ascii

/*routine isWhiteSpace returns a 0 if the character is not defined as a white space character and the position within the chain if it is. 1 defines the lowest, size(x) the highest priority*/
::ROUTINE isWhiteSpace 
	PARSE ARG char
	whites = .array~of(0,13,10,9,160,32)
	ret = 0
	if whites~hasItem(char) then
	do
		ret = whites~index(char)
	end
	

RETURN ret

/*rankChar takes into account two characters; it returns -1 if the previous has to be deleted, 0 if this pair has to be ignored and 1 if the current character has to be deleted.*/
::ROUTINE rankChar
	PARSE ARG previous current

	ret = 0
	
	current_idx = isWhiteSpace(current)
	previous_idx = isWhiteSpace(previous)
	if current_idx>0 & previous_idx>0 then
	do

		if current_idx < previous_idx then
		do
			ret = -1
		end
		else
		do
			ret = 1
		end
	end

RETURN ret

